/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.es.config.rest;

import ai.yue.library.base.config.net.http.SkipHostnameVerifier;
import ai.yue.library.base.config.net.http.SkipSslVerificationHttpRequestFactory;
import ai.yue.library.data.es.config.rest.EsRestProperties;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import javax.net.ssl.HostnameVerifier;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.RestClients;
import org.springframework.data.elasticsearch.config.AbstractElasticsearchConfiguration;

@Configuration
@EnableConfigurationProperties(value={EsRestProperties.class})
@ConditionalOnProperty(prefix="yue.es.rest", name={"enabled"}, havingValue="true")
public class EsRestConfig
extends AbstractElasticsearchConfiguration {
    @Autowired
    private EsRestProperties esRestProperties;

    @Bean
    @Primary
    public RestHighLevelClient elasticsearchClient() {
        ClientConfiguration.MaybeSecureClientConfigurationBuilder clientConfigurationBuilder = ClientConfiguration.builder().connectedTo((String[])ArrayUtil.toArray(this.esRestProperties.getHostAndPort(), String.class));
        if (this.esRestProperties.isUseSsl()) {
            boolean trustSelfSigned = this.esRestProperties.isTrustSelfSigned();
            boolean hostnameVerification = this.esRestProperties.isHostnameVerification();
            if (trustSelfSigned && !hostnameVerification) {
                clientConfigurationBuilder.usingSsl(SkipSslVerificationHttpRequestFactory.getSSLContext(), (HostnameVerifier)new SkipHostnameVerifier());
            } else if (trustSelfSigned) {
                clientConfigurationBuilder.usingSsl(SkipSslVerificationHttpRequestFactory.getSSLContext());
            } else {
                clientConfigurationBuilder.usingSsl();
            }
        }
        String username = this.esRestProperties.getUsername();
        String password = this.esRestProperties.getPassword();
        if (StrUtil.isNotEmpty((CharSequence)username) && StrUtil.isNotEmpty((CharSequence)password)) {
            clientConfigurationBuilder.withBasicAuth(username, password);
        }
        clientConfigurationBuilder.withConnectTimeout(this.esRestProperties.getConnectionTimeout());
        clientConfigurationBuilder.withSocketTimeout(this.esRestProperties.getReadTimeout());
        return RestClients.create((ClientConfiguration)clientConfigurationBuilder.build()).rest();
    }
}

