/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DBException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.DBDelete;
import ai.yue.library.data.jdbc.constant.DBUpdateEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.transaction.annotation.Transactional;

class DBInsert
extends DBDelete {
    DBInsert() {
    }

    private SimpleJdbcInsert insertInit(String tableName, JSONObject paramJson) {
        this.paramValidate(tableName, paramJson);
        SimpleJdbcInsert simpleJdbcInsert = new SimpleJdbcInsert(this.jdbcTemplate);
        simpleJdbcInsert.setTableName(tableName);
        simpleJdbcInsert.setGeneratedKeyName("id");
        List keys = MapUtils.keyList((Map)paramJson);
        List columnNames = ListUtils.toList(this.queryForList("desc " + tableName, MapUtils.FINAL_EMPTY_JSON), (String)"Field");
        List insertColumn = ListUtils.keepSameValue((List)keys, (List)columnNames);
        simpleJdbcInsert.setColumnNames(insertColumn);
        return simpleJdbcInsert;
    }

    @Transactional
    public Long insert(String tableName, JSONObject paramJson) {
        MapUtils.removeEmpty((Map)paramJson);
        SimpleJdbcInsert simpleJdbcInsert = this.insertInit(tableName, paramJson);
        return simpleJdbcInsert.executeAndReturnKey((Map)paramJson).longValue();
    }

    @Transactional
    public Long insertWithSortIdxAutoIncrement(String tableName, JSONObject paramJson, String ... uniqueKeys) {
        this.paramValidate(tableName, paramJson);
        int sort_idx = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT sort_idx FROM ");
        sql.append(tableName);
        String whereSql = this.paramToWhereSql(paramJson, uniqueKeys);
        sql.append(whereSql);
        sql.append(" ORDER BY sort_idx DESC LIMIT 1");
        JSONObject result = this.queryForJson(sql.toString(), paramJson);
        if (result != null) {
            sort_idx = result.getInteger("sort_idx") + 1;
        }
        paramJson.put("sort_idx", (Object)sort_idx);
        return this.insert(tableName, paramJson);
    }

    @Transactional
    public void insertBatch(String tableName, JSONObject[] paramJsons) {
        this.paramValidate(tableName, paramJsons);
        SimpleJdbcInsert simpleJdbcInsert = this.insertInit(tableName, paramJsons[0]);
        int updateRowsNumber = simpleJdbcInsert.executeBatch((Map[])paramJsons).length;
        if (updateRowsNumber != paramJsons.length) {
            throw new DBException("\u6267\u884c\u591a\u884c\u63d2\u5165\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional
    public Long insertOrUpdate(String tableName, JSONObject paramJson, String[] conditions, DBUpdateEnum dBUpdateEnum) {
        String key;
        this.paramValidate(tableName, paramJson, conditions);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        sql.append(" (");
        Set keys = paramJson.keySet();
        Iterator it = keys.iterator();
        Iterator iterator = keys.iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            sql.append(key);
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") VALUES (");
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            sql.append(":");
            sql.append(key);
            if (!iterator.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") ON DUPLICATE KEY UPDATE ");
        for (String condition : conditions) {
            sql.append(condition);
            sql.append(" = ");
            if (dBUpdateEnum == DBUpdateEnum.\u6b63\u5e38) {
                sql.append(":" + condition);
            } else {
                sql.append(condition);
                if (dBUpdateEnum == DBUpdateEnum.\u9012\u589e) {
                    sql.append(" + :");
                } else {
                    sql.append(" - :");
                }
                sql.append(condition);
            }
            sql.append(", ");
        }
        sql = StringUtils.deleteLastEqualString((StringBuffer)sql, (String)", ");
        return this.namedParameterJdbcTemplate.update(sql.toString(), (Map)paramJson);
    }
}

