/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.ipo;

import ai.yue.library.base.exception.ParamException;
import com.alibaba.fastjson.JSONObject;
import lombok.NonNull;

public class PageIPO {
    @NonNull
    Integer page;
    @NonNull
    Integer limit;
    JSONObject conditions;

    public static PageIPO parsePageIPO(JSONObject paramJson) {
        return PageIPO.parsePageIPO(paramJson, 200);
    }

    public static PageIPO parsePageIPO(JSONObject paramJson, int maxLimit) {
        Integer page = paramJson.getInteger("page");
        Integer limit = paramJson.getInteger("limit");
        if (null == page || null == limit) {
            throw new ParamException("null == page || null == limit");
        }
        paramJson.remove((Object)"page");
        paramJson.remove((Object)"limit");
        if (limit > maxLimit) {
            throw new ParamException("\u8d85\u51fa\u6700\u5927limit\u9650\u5236");
        }
        return PageIPO.builder().page(page).limit(limit).conditions(paramJson).build();
    }

    public static PageIPOBuilder builder() {
        return new PageIPOBuilder();
    }

    @NonNull
    public Integer getPage() {
        return this.page;
    }

    @NonNull
    public Integer getLimit() {
        return this.limit;
    }

    public JSONObject getConditions() {
        return this.conditions;
    }

    public void setPage(@NonNull Integer page) {
        if (page == null) {
            throw new NullPointerException("page");
        }
        this.page = page;
    }

    public void setLimit(@NonNull Integer limit) {
        if (limit == null) {
            throw new NullPointerException("limit");
        }
        this.limit = limit;
    }

    public void setConditions(JSONObject conditions) {
        this.conditions = conditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageIPO)) {
            return false;
        }
        PageIPO other = (PageIPO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        JSONObject this$conditions = this.getConditions();
        JSONObject other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageIPO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        JSONObject $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
        return result;
    }

    public String toString() {
        return "PageIPO(page=" + this.getPage() + ", limit=" + this.getLimit() + ", conditions=" + this.getConditions() + ")";
    }

    public PageIPO() {
    }

    public PageIPO(@NonNull Integer page, @NonNull Integer limit, JSONObject conditions) {
        if (page == null) {
            throw new NullPointerException("page");
        }
        if (limit == null) {
            throw new NullPointerException("limit");
        }
        this.page = page;
        this.limit = limit;
        this.conditions = conditions;
    }

    public static class PageIPOBuilder {
        private Integer page;
        private Integer limit;
        private JSONObject conditions;

        PageIPOBuilder() {
        }

        public PageIPOBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public PageIPOBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PageIPOBuilder conditions(JSONObject conditions) {
            this.conditions = conditions;
            return this;
        }

        public PageIPO build() {
            return new PageIPO(this.page, this.limit, this.conditions);
        }

        public String toString() {
            return "PageIPO.PageIPOBuilder(page=" + this.page + ", limit=" + this.limit + ", conditions=" + this.conditions + ")";
        }
    }
}

