/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DBException;
import ai.yue.library.base.util.ArithCompute;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.DBBase;
import ai.yue.library.data.jdbc.constant.DBSortEnum;
import ai.yue.library.data.jdbc.dto.PageDTO;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageBeforeAndAfterVO;
import ai.yue.library.data.jdbc.vo.PageTVO;
import ai.yue.library.data.jdbc.vo.PageVO;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;

class DBQuery
extends DBBase {
    private static final Logger log = LoggerFactory.getLogger(DBQuery.class);

    DBQuery() {
    }

    private String querySql(String tableName, JSONObject paramJson, DBSortEnum dBSortEnum) {
        this.paramValidate(tableName, paramJson);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        sql.append(tableName);
        String whereSql = this.paramToWhereSql(paramJson);
        sql.append(whereSql);
        if (dBSortEnum == DBSortEnum.\u5347\u5e8f) {
            sql.append(" ORDER BY id");
        } else if (dBSortEnum == DBSortEnum.\u964d\u5e8f) {
            sql.append(" ORDER BY id DESC");
        }
        return sql.toString();
    }

    public List<JSONObject> query(String tableName, JSONObject paramJson) {
        String sql = this.querySql(tableName, paramJson, null);
        return ListUtils.toJsonList((List)this.namedParameterJdbcTemplate.queryForList(sql, (Map)paramJson));
    }

    public <T> List<T> query(String tableName, JSONObject paramJson, Class<T> mappedClass) {
        String sql = this.querySql(tableName, paramJson, null);
        return this.namedParameterJdbcTemplate.query(sql, (Map)paramJson, (RowMapper)BeanPropertyRowMapper.newInstance(mappedClass));
    }

    public List<JSONObject> query(String tableName, JSONObject paramJson, DBSortEnum dBSortEnum) {
        String sql = this.querySql(tableName, paramJson, dBSortEnum);
        return ListUtils.toJsonList((List)this.namedParameterJdbcTemplate.queryForList(sql, (Map)paramJson));
    }

    public <T> List<T> query(String tableName, JSONObject paramJson, Class<T> mappedClass, DBSortEnum dBSortEnum) {
        String sql = this.querySql(tableName, paramJson, dBSortEnum);
        return this.namedParameterJdbcTemplate.query(sql, (Map)paramJson, (RowMapper)BeanPropertyRowMapper.newInstance(mappedClass));
    }

    private String queryByIdSql(String tableName, Long id) {
        this.paramValidate(tableName, id);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        sql.append(tableName);
        sql.append(" WHERE id = :id ");
        return sql.toString();
    }

    public JSONObject queryById(String tableName, long id) {
        String sql = this.queryByIdSql(tableName, id);
        JSONObject paramJson = new JSONObject();
        paramJson.put("id", (Object)id);
        return this.queryForJson(sql, paramJson);
    }

    public <T> T queryById(String tableName, Long id, Class<T> mappedClass) {
        String sql = this.queryByIdSql(tableName, id);
        JSONObject paramJson = new JSONObject();
        paramJson.put("id", (Object)id);
        return this.queryForObject(sql, paramJson, mappedClass);
    }

    private String queryByIdSql(String tableName, Long id, String[] fieldName) {
        this.paramValidate(tableName, id, fieldName);
        String field = StringUtils.deleteFirstLastString((String)Arrays.toString(fieldName), (int)1);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(field);
        sql.append(" FROM ");
        sql.append(tableName);
        sql.append(" WHERE id = :id ");
        return sql.toString();
    }

    public JSONObject queryById(String tableName, Long id, String ... fieldName) {
        String sql = this.queryByIdSql(tableName, id, fieldName);
        JSONObject paramJson = new JSONObject();
        paramJson.put("id", (Object)id);
        return this.queryForJson(sql, paramJson);
    }

    private String queryAllSql(String tableName) {
        this.paramValidate(tableName);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        sql.append(tableName);
        return sql.toString();
    }

    public List<JSONObject> queryAll(String tableName) {
        String sql = this.queryAllSql(tableName);
        return this.queryForList(sql, MapUtils.FINAL_EMPTY_JSON);
    }

    public <T> List<T> queryAll(String tableName, Class<T> mappedClass) {
        String sql = this.queryAllSql(tableName);
        return this.namedParameterJdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(mappedClass));
    }

    public JSONObject queryForJson(String sql, JSONObject paramJson) {
        List<JSONObject> list = this.queryForList(sql, paramJson);
        return this.resultToJson(list);
    }

    public <T> T queryForObject(String sql, JSONObject paramJson, Class<T> mappedClass) {
        try {
            return (T)this.namedParameterJdbcTemplate.queryForObject(sql, (Map)paramJson, (RowMapper)BeanPropertyRowMapper.newInstance(mappedClass));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public List<JSONObject> queryForList(String sql, JSONObject paramJson) {
        return ListUtils.toJsonList((List)this.namedParameterJdbcTemplate.queryForList(sql, (Map)paramJson));
    }

    public <T> List<T> queryForList(String sql, JSONObject paramJson, Class<T> mappedClass) {
        return this.namedParameterJdbcTemplate.query(sql, (Map)paramJson, (RowMapper)BeanPropertyRowMapper.newInstance(mappedClass));
    }

    private JSONObject pageIPO(PageIPO pageIPO) {
        int page = pageIPO.getPage();
        int limit = pageIPO.getLimit();
        JSONObject conditions = pageIPO.getConditions();
        if (--page >= 1) {
            page = (int)ArithCompute.mul((double)page, (double)limit);
        }
        JSONObject paramJson = new JSONObject();
        paramJson.put("page", (Object)page);
        paramJson.put("limit", (Object)limit);
        if (null != conditions && !conditions.isEmpty()) {
            paramJson.putAll((Map)conditions);
        }
        return paramJson;
    }

    private PageDTO pageDTO(String tableName, PageIPO pageIPO, DBSortEnum dBSortEnum) {
        this.paramValidate(tableName);
        JSONObject paramJson = this.pageIPO(pageIPO);
        JSONObject conditions = pageIPO.getConditions();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT a.* FROM ");
        querySql.append(tableName + " a, ");
        querySql.append("(SELECT id FROM ");
        querySql.append(tableName);
        String whereSql = "";
        if (conditions != null) {
            whereSql = this.paramToWhereSql(conditions);
        }
        querySql.append(whereSql);
        if (dBSortEnum == null) {
            querySql.append(" LIMIT :page, :limit) b WHERE a.id = b.id");
        } else if (DBSortEnum.\u5347\u5e8f == dBSortEnum) {
            querySql.append(" ORDER BY id LIMIT :page, :limit) b WHERE a.id = b.id");
        } else {
            querySql.append(" ORDER BY id DESC LIMIT :page, :limit) b WHERE a.id = b.id");
        }
        StringBuffer countSql = new StringBuffer();
        countSql.append("SELECT COUNT(*) count FROM ");
        countSql.append(tableName);
        countSql.append(whereSql);
        Long count = (Long)this.namedParameterJdbcTemplate.queryForMap(countSql.toString(), (Map)paramJson).get("count");
        return PageDTO.builder().count(count).querySql(querySql.toString()).paramJson(paramJson).build();
    }

    private PageVO pageVO(PageDTO pageDTO) {
        Long count = pageDTO.getCount();
        String querySql = pageDTO.getQuerySql();
        JSONObject paramJson = pageDTO.getParamJson();
        ArrayList<JSONObject> data = new ArrayList();
        if (count == null || count != 0L) {
            data = ListUtils.toJsonList((List)this.namedParameterJdbcTemplate.queryForList(querySql, (Map)paramJson));
        }
        return PageVO.builder().count(count).data(data).build();
    }

    private <T> PageTVO<T> pageTVO(PageDTO pageDTO, Class<T> mappedClass) {
        Long count = pageDTO.getCount();
        String querySql = pageDTO.getQuerySql();
        JSONObject paramJson = pageDTO.getParamJson();
        List data = new ArrayList();
        if (count != 0L) {
            data = this.namedParameterJdbcTemplate.query(querySql, (Map)paramJson, (RowMapper)BeanPropertyRowMapper.newInstance(mappedClass));
        }
        PageTVO pageTVO = new PageTVO();
        return pageTVO.toBuilder().count(count).data(data).build();
    }

    public PageVO page(String tableName, PageIPO pageIPO) {
        PageDTO pageDTO = this.pageDTO(tableName, pageIPO, null);
        return this.pageVO(pageDTO);
    }

    public <T> PageTVO<T> page(String tableName, PageIPO pageIPO, Class<T> mappedClass) {
        PageDTO pageDTO = this.pageDTO(tableName, pageIPO, null);
        return this.pageTVO(pageDTO, mappedClass);
    }

    public PageVO page(String tableName, PageIPO pageIPO, DBSortEnum dBSortEnum) {
        PageDTO pageDTO = this.pageDTO(tableName, pageIPO, dBSortEnum);
        return this.pageVO(pageDTO);
    }

    public <T> PageTVO<T> page(String tableName, PageIPO pageIPO, Class<T> mappedClass, DBSortEnum dBSortEnum) {
        PageDTO pageDTO = this.pageDTO(tableName, pageIPO, dBSortEnum);
        return this.pageTVO(pageDTO, mappedClass);
    }

    private PageDTO pageWhereDTO(String tableName, String whereSql, PageIPO pageIPO) {
        this.paramValidate(tableName, whereSql);
        JSONObject paramJson = this.pageIPO(pageIPO);
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT a.* FROM ");
        querySql.append(tableName + " a, ");
        querySql.append(" (select id from ");
        querySql.append(tableName);
        querySql.append(" ");
        querySql.append(whereSql);
        querySql.append(" LIMIT :page, :limit) b WHERE a.id = b.id");
        StringBuffer countSql = new StringBuffer();
        countSql.append("SELECT COUNT(*) count FROM ");
        countSql.append(tableName);
        countSql.append(" ");
        countSql.append(whereSql);
        Long count = (Long)this.namedParameterJdbcTemplate.queryForMap(countSql.toString(), (Map)paramJson).get("count");
        return PageDTO.builder().count(count).querySql(querySql.toString()).paramJson(paramJson).build();
    }

    public PageVO pageWhere(String tableName, String whereSql, PageIPO pageIPO) {
        PageDTO pageDTO = this.pageWhereDTO(tableName, whereSql, pageIPO);
        return this.pageVO(pageDTO);
    }

    public <T> PageTVO<T> pageWhere(String tableName, String whereSql, PageIPO pageIPO, Class<T> mappedClass) {
        PageDTO pageDTO = this.pageWhereDTO(tableName, whereSql, pageIPO);
        return this.pageTVO(pageDTO, mappedClass);
    }

    private PageDTO pageSqlDTO(String querySql, PageIPO pageIPO) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DBException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject paramJson = this.pageIPO(pageIPO);
        JSONObject conditions = pageIPO.getConditions();
        int fromIndex = querySql.toUpperCase().indexOf("FROM");
        String countStr = "SELECT count(*) count " + querySql.substring(fromIndex);
        int limitIndex = countStr.toUpperCase().indexOf("LIMIT");
        if (-1 == limitIndex) {
            throw new DBException("querySql\u4e0d\u80fd\u6ca1\u6709LIMIT");
        }
        int EndIndex = countStr.indexOf(")", limitIndex);
        if (-1 == EndIndex) {
            System.err.println("\u9519\u8bef\u7684querySql\uff1a\n");
            System.err.println(querySql);
            throw new DBException("querySql\u5e94\u5f53\u662f\u4e00\u4e2a\u4f18\u5316\u540e\u7684\u8bed\u53e5\uff0c\u5176\u4e2dLIMIT\u5fc5\u987b\u653e\u5728\u5b50\u67e5\u8be2\u5185\uff0c\u8be6\u7ec6\u8bf7\u53c2\u7167\u793a\u4f8b\u8bed\u53e5\u7f16\u5199\u3002");
        }
        StringBuffer countSql = new StringBuffer(countStr);
        countSql = countSql.delete(limitIndex, EndIndex);
        Long count = (Long)this.namedParameterJdbcTemplate.queryForMap(countSql.toString(), (Map)conditions).get("count");
        return PageDTO.builder().count(count).querySql(querySql.toString()).paramJson(paramJson).build();
    }

    private PageDTO pageSqlDTO(String countSql, String querySql, PageIPO pageIPO) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DBException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject paramJson = this.pageIPO(pageIPO);
        JSONObject conditions = pageIPO.getConditions();
        Long count = null;
        if (!StringUtils.isEmpty((CharSequence)countSql)) {
            count = (Long)this.namedParameterJdbcTemplate.queryForMap(countSql, (Map)conditions).get("count");
        }
        return PageDTO.builder().count(count).querySql(querySql.toString()).paramJson(paramJson).build();
    }

    public PageVO pageSql(String querySql, PageIPO pageIPO) {
        PageDTO pageDTO = this.pageSqlDTO(querySql, pageIPO);
        return this.pageVO(pageDTO);
    }

    public <T> PageTVO<T> pageSql(String querySql, PageIPO pageIPO, Class<T> mappedClass) {
        PageDTO pageDTO = this.pageSqlDTO(querySql, pageIPO);
        return this.pageTVO(pageDTO, mappedClass);
    }

    public PageVO pageSql(String countSql, String querySql, PageIPO pageIPO) {
        PageDTO pageDTO = this.pageSqlDTO(countSql, querySql, pageIPO);
        return this.pageVO(pageDTO);
    }

    public <T> PageTVO<T> pageSql(String countSql, String querySql, PageIPO pageIPO, Class<T> mappedClass) {
        PageDTO pageDTO = this.pageSqlDTO(countSql, querySql, pageIPO);
        return this.pageTVO(pageDTO, mappedClass);
    }

    public PageBeforeAndAfterVO pageBeforeAndAfter(String querySql, PageIPO pageIPO, Long equalsId) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DBException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int page = pageIPO.getPage();
        int limit = pageIPO.getLimit();
        JSONObject conditions = pageIPO.getConditions();
        if (--page >= 1) {
            page = (int)ArithCompute.mul((double)page, (double)limit);
        }
        if (page > 0) {
            --page;
        }
        conditions.put("page", (Object)page);
        conditions.put("limit", (Object)(++limit));
        JSONArray array = new JSONArray();
        array.addAll((Collection)this.namedParameterJdbcTemplate.queryForList(querySql, (Map)conditions));
        int size = array.size();
        Long before_id = null;
        Long after_id = null;
        String key = "id";
        for (int i = 0; i < size; ++i) {
            JSONObject json = array.getJSONObject(i);
            if (!equalsId.equals(json.getLong(key))) continue;
            if (i != 0) {
                before_id = array.getJSONObject(i - 1).getLong(key);
            }
            if (i == size - 1) break;
            after_id = array.getJSONObject(i + 1).getLong(key);
            break;
        }
        return PageBeforeAndAfterVO.builder().before_id(before_id).after_id(after_id).build();
    }
}

