/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DBException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.DBQuery;
import ai.yue.library.data.jdbc.constant.DBExpectedValueModeEnum;
import ai.yue.library.data.jdbc.constant.DBUpdateEnum;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

class DBUpdate
extends DBQuery {
    DBUpdate() {
    }

    private String updateSql(String tableName, JSONObject paramJson, String[] conditions, DBUpdateEnum dBUpdateEnum) {
        this.paramValidate(tableName, paramJson, conditions);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        Set keys = paramJson.keySet();
        for (String key : keys) {
            if (ArrayUtil.contains((Object[])conditions, (Object)key)) continue;
            sql.append(key);
            sql.append(" = ");
            if (dBUpdateEnum == DBUpdateEnum.\u9012\u589e) {
                sql.append(key);
                sql.append(" + :");
            } else if (dBUpdateEnum == DBUpdateEnum.\u9012\u51cf || dBUpdateEnum == DBUpdateEnum.\u9012\u51cf_\u65e0\u7b26\u53f7) {
                sql.append(key);
                sql.append(" - :");
            } else {
                sql.append(":");
            }
            sql.append(key);
            sql.append(", ");
        }
        sql = StringUtils.deleteLastEqualString((StringBuffer)sql, (String)", ");
        String whereSql = this.paramToWhereSql(paramJson, conditions);
        sql.append(whereSql);
        if (dBUpdateEnum == DBUpdateEnum.\u9012\u51cf_\u65e0\u7b26\u53f7) {
            List updateKeys = MapUtils.keyList((Map)paramJson);
            for (String key : updateKeys) {
                if (ArrayUtil.contains((Object[])conditions, (Object)key)) continue;
                sql.append(" AND ");
                sql.append(key);
                sql.append(" >= :");
                sql.append(key);
            }
        }
        return sql.toString();
    }

    @Transactional
    public Long update(String tableName, JSONObject paramJson, String[] conditions) {
        String sql = this.updateSql(tableName, paramJson, conditions, DBUpdateEnum.\u6b63\u5e38);
        return this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
    }

    @Transactional
    public Long update(String tableName, JSONObject paramJson, String[] conditions, DBUpdateEnum dBUpdateEnum) {
        String sql = this.updateSql(tableName, paramJson, conditions, dBUpdateEnum);
        return this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
    }

    @Transactional
    public void update(String tableName, JSONObject paramJson, String[] conditions, DBUpdateEnum dBUpdateEnum, int expectedValue, DBExpectedValueModeEnum dBExpectedValueModeEnum) {
        String sql = this.updateSql(tableName, paramJson, conditions, dBUpdateEnum);
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        if (DBExpectedValueModeEnum.\u7b49\u4e8e == dBExpectedValueModeEnum) {
            this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        } else if (DBExpectedValueModeEnum.\u5927\u4e8e\u7b49\u4e8e == dBExpectedValueModeEnum) {
            this.updateAndExpectedGreaterThanEqual(updateRowsNumber, expectedValue);
        }
    }

    @Transactional
    public long update(String sql, JSONObject paramJson) {
        return this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
    }

    @Transactional
    public void update(String sql, JSONObject paramJson, int expectedValue, DBExpectedValueModeEnum dBExpectedValueModeEnum) {
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        if (DBExpectedValueModeEnum.\u7b49\u4e8e == dBExpectedValueModeEnum) {
            this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        } else if (DBExpectedValueModeEnum.\u5927\u4e8e\u7b49\u4e8e == dBExpectedValueModeEnum) {
            this.updateAndExpectedGreaterThanEqual(updateRowsNumber, expectedValue);
        }
    }

    @Transactional
    public void updateById(String tableName, JSONObject paramJson) {
        this.updateById(tableName, paramJson, DBUpdateEnum.\u6b63\u5e38);
    }

    @Transactional
    public void updateById(String tableName, JSONObject paramJson, DBUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{"id"};
        String sql = this.updateSql(tableName, paramJson, conditions, dBUpdateEnum);
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
    }

    @Transactional
    public void updateById(String tableName, JSONObject[] paramJsons, DBUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{"id"};
        String sql = this.updateSql(tableName, paramJsons[0], conditions, dBUpdateEnum);
        int[] updateRowsNumberArray = this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }

    @Transactional
    public void updateSort(String tableName, Long id, Integer move, String ... uniqueKeys) {
        int i;
        this.paramValidate(tableName);
        if (move == 0) {
            throw new DBException("move <= 0");
        }
        String id_key = "id";
        String sort_idx_key = "sort_idx";
        JSONObject sortJSON = this.queryById(tableName, id);
        int sortIdx = sortJSON.getInteger(sort_idx_key);
        int updateSortIdx = sortIdx + move;
        if (updateSortIdx < 1) {
            throw new DBException("\u6392\u5e8f\u540e\u7684\u7d22\u5f15\u503c\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        ArrayList<Integer> updateSortList = new ArrayList<Integer>();
        boolean isASC = false;
        if (updateSortIdx > sortIdx) {
            isASC = true;
            for (i = updateSortIdx; i > sortIdx; --i) {
                updateSortList.add(i);
            }
        } else {
            for (i = updateSortIdx; i < sortIdx; ++i) {
                updateSortList.add(i);
            }
        }
        JSONObject paramJson = new JSONObject();
        if (ArrayUtil.isNotEmpty((Object[])uniqueKeys)) {
            for (String uniqueKey : uniqueKeys) {
                Object uniqueValue = sortJSON.get((Object)uniqueKey);
                paramJson.put(uniqueKey, uniqueValue);
            }
        }
        paramJson.put(sort_idx_key, updateSortList);
        List<JSONObject> list = this.query(tableName, paramJson);
        JSONArray paramJsonArray = new JSONArray();
        for (JSONObject actionJSON : list) {
            Long actionId = actionJSON.getLong(id_key);
            Integer actionSort = actionJSON.getInteger(sort_idx_key);
            actionSort = isASC ? Integer.valueOf(actionSort - 1) : Integer.valueOf(actionSort + 1);
            JSONObject actionParamJSON = new JSONObject();
            actionParamJSON.put(id_key, (Object)actionId);
            actionParamJSON.put(sort_idx_key, (Object)actionSort);
            paramJsonArray.add((Object)actionParamJSON);
        }
        JSONObject updateSortParam = new JSONObject();
        updateSortParam.put(id_key, (Object)id);
        updateSortParam.put(sort_idx_key, (Object)updateSortIdx);
        paramJsonArray.add((Object)updateSortParam);
        this.updateById(tableName, ListUtils.toJsons((JSONArray)paramJsonArray), DBUpdateEnum.\u6b63\u5e38);
    }

    @Transactional
    public void updateBatch(String tableName, JSONObject[] paramJsons, String[] conditions, DBUpdateEnum dBUpdateEnum) {
        String sql = this.updateSql(tableName, paramJsons[0], conditions, dBUpdateEnum);
        int[] updateRowsNumberArray = this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }

    @Transactional
    public int[] updateBatch(String sql, JSONObject[] paramJsons) {
        return this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons);
    }
}

