/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.data.jdbc.client.DbInsert;
import ai.yue.library.data.jdbc.client.dialect.Dialect;
import ai.yue.library.data.jdbc.client.dialect.impl.MysqlDialect;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class Db
extends DbInsert
implements Cloneable {
    public Db(DataSource dataSource) {
        this(new NamedParameterJdbcTemplate(dataSource));
    }

    public Db(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = namedParameterJdbcTemplate.getJdbcTemplate();
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.dialect = new MysqlDialect(namedParameterJdbcTemplate);
    }

    public Db(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedParameterJdbcTemplate, Dialect dialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.dialect = dialect;
    }

    public Db clone() {
        Db db = new Db(this.jdbcTemplate, this.namedParameterJdbcTemplate, this.dialect);
        db.setBusinessUk(this.businessUk);
        db.setDatabaseFieldNamingStrategy(this.databaseFieldNamingStrategy);
        db.setDatabaseFieldNamingStrategyRecognitionEnabled(this.databaseFieldNamingStrategyRecognitionEnabled);
        db.setEnableDeleteQueryFilter(this.enableDeleteQueryFilter);
        return db;
    }
}

