/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.data.jdbc.client.DbUpdate;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

class DbDelete
extends DbUpdate {
    DbDelete() {
    }

    private String deleteSqlBuild(String tableName, JSONObject paramJson) {
        this.paramValidate(tableName, paramJson);
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        sql.append(this.paramToWhereSql(paramJson));
        return sql.toString();
    }

    @Transactional
    public void delete(String tableName, Long id) {
        this.paramValidate(tableName, id);
        JSONObject paramJson = new JSONObject();
        paramJson.put("id", (Object)id);
        String sql = this.deleteSqlBuild(tableName, paramJson);
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        if (updateRowsNumber != 1) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    public void deleteSafe(String tableName, Long id) {
        JSONObject data = this.getById(tableName, id);
        if (data == null || data.isEmpty()) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u5f02\u5e38\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5b58\u5728\u591a\u6761\u6570\u636e", true);
        }
        this.delete(tableName, id);
    }

    @Transactional
    public long delete(String tableName, JSONObject paramJson) {
        String sql = this.deleteSqlBuild(tableName, paramJson);
        return this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
    }

    @Transactional
    public void deleteBatch(String tableName, JSONObject[] paramJsons) {
        int[] updateRowsNumberArray;
        String sql = this.deleteSqlBuild(tableName, paramJsons[0]);
        for (int updateRowsNumber : updateRowsNumberArray = this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons)) {
            if (updateRowsNumber <= 1) continue;
            throw new DbException("\u6267\u884c\u6279\u6b21\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional
    public int[] deleteBatch2(String sql, JSONObject[] paramJsons) {
        return this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons);
    }

    private String deleteLogicSqlBuild(String tableName, JSONObject paramJson) {
        this.paramValidate(tableName, paramJson);
        String[] conditions = new String[paramJson.size()];
        conditions = MapUtils.keyList((Map)paramJson).toArray(conditions);
        paramJson.put("delete_time", (Object)System.currentTimeMillis());
        return this.dialect.updateSqlBuild(tableName, paramJson, conditions, DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void deleteLogic(String tableName, Long id) {
        this.paramValidate(tableName, id);
        JSONObject paramJson = new JSONObject();
        paramJson.put("id", (Object)id);
        String sql = this.deleteLogicSqlBuild(tableName, paramJson);
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        if (updateRowsNumber != 1) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional
    public long deleteLogic(String tableName, JSONObject paramJson) {
        String sql = this.deleteLogicSqlBuild(tableName, paramJson);
        return this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
    }

    @Transactional
    public void deleteBatchLogic(String tableName, JSONObject[] paramJsons) {
        int[] updateRowsNumberArray;
        String sql = this.deleteLogicSqlBuild(tableName, paramJsons[0]);
        for (int updateRowsNumber : updateRowsNumberArray = this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons)) {
            if (updateRowsNumber <= 1) continue;
            throw new DbException("\u6267\u884c\u6279\u6b21\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }
}

