/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.DbJdbcTemplate;
import ai.yue.library.data.jdbc.constant.DbConstant;
import ai.yue.library.data.jdbc.constant.DbSortEnum;
import ai.yue.library.data.jdbc.dto.PageDTO;
import ai.yue.library.data.jdbc.ipo.Page;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.support.BeanPropertyRowMapper;
import ai.yue.library.data.jdbc.vo.PageBeforeAndAfterVO;
import ai.yue.library.data.jdbc.vo.PageTVO;
import ai.yue.library.data.jdbc.vo.PageVO;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.lang.Nullable;

class DbQuery
extends DbJdbcTemplate {
    private static final Logger log = LoggerFactory.getLogger(DbQuery.class);

    DbQuery() {
    }

    public <T> T queryObject(String sql, JSONObject paramJson, Class<T> mappedClass) {
        try {
            return (T)this.namedParameterJdbcTemplate.queryForObject(sql, (Map)paramJson, mappedClass);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public JSONObject queryForJson(String sql, JSONObject paramJson) {
        List<JSONObject> list = this.queryForList(sql, paramJson);
        return this.resultToJson(list);
    }

    public <T> T queryForObject(String sql, JSONObject paramJson, Class<T> mappedClass) {
        try {
            return (T)this.namedParameterJdbcTemplate.queryForObject(sql, (Map)paramJson, BeanPropertyRowMapper.newInstance(mappedClass));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public SqlRowSet queryForRowSet(String sql, JSONObject paramJson) {
        return this.namedParameterJdbcTemplate.queryForRowSet(sql, (Map)paramJson);
    }

    public List<JSONObject> queryForList(String sql, JSONObject paramJson) {
        return ListUtils.toJsonList((List)this.namedParameterJdbcTemplate.queryForList(sql, (Map)paramJson));
    }

    public <T> List<T> queryForList(String sql, JSONObject paramJson, Class<T> mappedClass) {
        return this.namedParameterJdbcTemplate.query(sql, (Map)paramJson, BeanPropertyRowMapper.newInstance(mappedClass));
    }

    public boolean isDataSize(String tableName, JSONObject paramJson) {
        return MapUtils.isNotEmpty((Map)this.get(tableName, paramJson));
    }

    public SqlRowSetMetaData getMetaData(String tableName) {
        tableName = this.dialect.getWrapper().wrap(tableName);
        StringBuffer sql = new StringBuffer("SELECT * FROM ").append(tableName).append(this.dialect.getPageJoinSql());
        return this.queryForRowSet(sql.toString(), Page.builder().page(0L).limit(0).build().toParamJson()).getMetaData();
    }

    private String getByColumnNameSqlBuild(String tableName, String columnName) {
        this.paramValidate(tableName);
        if (StringUtils.isEmpty((CharSequence)columnName)) {
            throw new DbException("\u6761\u4ef6\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        tableName = this.dialect.getWrapper().wrap(tableName);
        columnName = this.dialect.getWrapper().wrap(columnName);
        StringBuffer sql = new StringBuffer("SELECT * FROM ");
        sql.append(tableName);
        sql.append(" WHERE ").append(columnName).append(" = :").append(columnName);
        if (this.enableDeleteQueryFilter) {
            sql.append(" AND ").append("delete_time").append(" = ").append(DbConstant.FIELD_DEFAULT_VALUE_DELETE_TIME);
        }
        return sql.toString();
    }

    public JSONObject getById(String tableName, long id) {
        this.paramValidate(tableName, id);
        String sql = this.getByColumnNameSqlBuild(tableName, "id");
        JSONObject paramJson = new JSONObject();
        paramJson.put(this.dialect.getWrapper().wrap("id"), (Object)id);
        return this.queryForJson(sql, paramJson);
    }

    public <T> T getById(String tableName, Long id, Class<T> mappedClass) {
        this.paramValidate(tableName, id);
        String sql = this.getByColumnNameSqlBuild(tableName, "id");
        JSONObject paramJson = new JSONObject();
        paramJson.put(this.dialect.getWrapper().wrap("id"), (Object)id);
        return this.queryForObject(sql, paramJson, mappedClass);
    }

    public JSONObject getByBusinessUk(String tableName, Object businessUkValue) {
        String sql = this.getByColumnNameSqlBuild(tableName, this.businessUk);
        JSONObject paramJson = new JSONObject();
        paramJson.put(this.dialect.getWrapper().wrap(this.businessUk), businessUkValue);
        return this.queryForJson(sql, paramJson);
    }

    public <T> T getByBusinessUk(String tableName, Object businessUkValue, Class<T> mappedClass) {
        String sql = this.getByColumnNameSqlBuild(tableName, this.businessUk);
        JSONObject paramJson = new JSONObject();
        paramJson.put(this.dialect.getWrapper().wrap(this.businessUk), businessUkValue);
        return this.queryForObject(sql, paramJson, mappedClass);
    }

    public JSONObject get(String tableName, JSONObject paramJson) {
        String sql = this.listSqlBuild(tableName, paramJson, null);
        return this.queryForJson(sql, paramJson);
    }

    public <T> T get(String tableName, JSONObject paramJson, Class<T> mappedClass) {
        String sql = this.listSqlBuild(tableName, paramJson, null);
        return this.queryForObject(sql, paramJson, mappedClass);
    }

    private String listSqlBuild(String tableName, JSONObject paramJson, DbSortEnum dBSortEnum) {
        this.paramValidate(tableName, paramJson);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        String whereSql = this.paramToWhereSql(paramJson);
        sql.append(whereSql);
        if (dBSortEnum == DbSortEnum.ASC) {
            sql.append(" ORDER BY id");
        } else if (dBSortEnum == DbSortEnum.DESC) {
            sql.append(" ORDER BY id DESC");
        }
        return sql.toString();
    }

    public List<JSONObject> list(String tableName, JSONObject paramJson) {
        String sql = this.listSqlBuild(tableName, paramJson, null);
        return ListUtils.toJsonList((List)this.namedParameterJdbcTemplate.queryForList(sql, (Map)paramJson));
    }

    public <T> List<T> list(String tableName, JSONObject paramJson, Class<T> mappedClass) {
        String sql = this.listSqlBuild(tableName, paramJson, null);
        return this.namedParameterJdbcTemplate.query(sql, (Map)paramJson, BeanPropertyRowMapper.newInstance(mappedClass));
    }

    public List<JSONObject> list(String tableName, JSONObject paramJson, DbSortEnum dBSortEnum) {
        String sql = this.listSqlBuild(tableName, paramJson, dBSortEnum);
        return ListUtils.toJsonList((List)this.namedParameterJdbcTemplate.queryForList(sql, (Map)paramJson));
    }

    public <T> List<T> list(String tableName, JSONObject paramJson, Class<T> mappedClass, DbSortEnum dBSortEnum) {
        String sql = this.listSqlBuild(tableName, paramJson, dBSortEnum);
        return this.namedParameterJdbcTemplate.query(sql, (Map)paramJson, BeanPropertyRowMapper.newInstance(mappedClass));
    }

    private String listAllSqlBuild(String tableName) {
        this.paramValidate(tableName);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        return sql.toString();
    }

    public List<JSONObject> listAll(String tableName) {
        String sql = this.listAllSqlBuild(tableName);
        return this.queryForList(sql, MapUtils.FINAL_EMPTY_JSON);
    }

    public <T> List<T> listAll(String tableName, Class<T> mappedClass) {
        String sql = this.listAllSqlBuild(tableName);
        return this.namedParameterJdbcTemplate.query(sql, BeanPropertyRowMapper.newInstance(mappedClass));
    }

    protected PageVO toPageVO(PageDTO pageDTO) {
        Long count = pageDTO.getCount();
        String querySql = pageDTO.getQuerySql();
        JSONObject paramJson = pageDTO.getParamJson();
        ArrayList<JSONObject> data = new ArrayList();
        if (count == null || count != 0L) {
            data = ListUtils.toJsonList((List)this.namedParameterJdbcTemplate.queryForList(querySql, (Map)paramJson));
        }
        return PageVO.builder().count(count).data(data).build();
    }

    protected <T> PageTVO<T> toPageTVO(PageDTO pageDTO, Class<T> mappedClass) {
        Long count = pageDTO.getCount();
        String querySql = pageDTO.getQuerySql();
        JSONObject paramJson = pageDTO.getParamJson();
        List data = new ArrayList();
        if (count != 0L) {
            data = this.namedParameterJdbcTemplate.query(querySql, (Map)paramJson, BeanPropertyRowMapper.newInstance(mappedClass));
        }
        PageTVO pageTVO = new PageTVO();
        return pageTVO.toBuilder().count(count).data(data).build();
    }

    public PageVO page(String tableName, PageIPO pageIPO) {
        PageDTO pageDTO = this.dialect.pageDTOBuild(tableName, pageIPO, null);
        return this.toPageVO(pageDTO);
    }

    public <T> PageTVO<T> page(String tableName, PageIPO pageIPO, Class<T> mappedClass) {
        PageDTO pageDTO = this.dialect.pageDTOBuild(tableName, pageIPO, null);
        return this.toPageTVO(pageDTO, mappedClass);
    }

    public PageVO page(String tableName, PageIPO pageIPO, DbSortEnum dBSortEnum) {
        PageDTO pageDTO = this.dialect.pageDTOBuild(tableName, pageIPO, dBSortEnum);
        return this.toPageVO(pageDTO);
    }

    public <T> PageTVO<T> page(String tableName, PageIPO pageIPO, Class<T> mappedClass, DbSortEnum dBSortEnum) {
        PageDTO pageDTO = this.dialect.pageDTOBuild(tableName, pageIPO, dBSortEnum);
        return this.toPageTVO(pageDTO, mappedClass);
    }

    public PageVO pageWhere(String tableName, String whereSql, PageIPO pageIPO) {
        PageDTO pageDTO = this.dialect.pageDTOBuild(tableName, whereSql, pageIPO);
        return this.toPageVO(pageDTO);
    }

    public <T> PageTVO<T> pageWhere(String tableName, String whereSql, PageIPO pageIPO, Class<T> mappedClass) {
        PageDTO pageDTO = this.dialect.pageDTOBuild(tableName, whereSql, pageIPO);
        return this.toPageTVO(pageDTO, mappedClass);
    }

    private PageDTO pageDTOBuild(String countSql, String querySql, PageIPO pageIPO) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DbException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject paramJson = this.dialect.toParamJson(pageIPO);
        JSONObject conditions = pageIPO.getConditions();
        Long count = null;
        if (!StringUtils.isEmpty((CharSequence)countSql)) {
            count = (Long)this.namedParameterJdbcTemplate.queryForMap(countSql, (Map)conditions).get("count");
        }
        return PageDTO.builder().count(count).querySql(querySql.toString()).paramJson(paramJson).build();
    }

    public PageVO pageSql(String querySql, PageIPO pageIPO) {
        PageDTO pageDTO = this.dialect.pageDTOBuild(querySql, pageIPO);
        return this.toPageVO(pageDTO);
    }

    public <T> PageTVO<T> pageSql(String querySql, PageIPO pageIPO, Class<T> mappedClass) {
        PageDTO pageDTO = this.dialect.pageDTOBuild(querySql, pageIPO);
        return this.toPageTVO(pageDTO, mappedClass);
    }

    public PageVO pageSql(@Nullable String countSql, String querySql, PageIPO pageIPO) {
        PageDTO pageDTO = this.pageDTOBuild(countSql, querySql, pageIPO);
        return this.toPageVO(pageDTO);
    }

    public <T> PageTVO<T> pageSql(@Nullable String countSql, String querySql, PageIPO pageIPO, Class<T> mappedClass) {
        PageDTO pageDTO = this.pageDTOBuild(countSql, querySql, pageIPO);
        return this.toPageTVO(pageDTO, mappedClass);
    }

    public PageBeforeAndAfterVO pageBeforeAndAfter(String querySql, PageIPO pageIPO, Long equalsId) {
        return this.dialect.pageBeforeAndAfter(querySql, pageIPO, equalsId);
    }
}

