/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.data.jdbc.client.DbQuery;
import ai.yue.library.data.jdbc.constant.DbExpectedValueModeEnum;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.transaction.annotation.Transactional;

class DbUpdate
extends DbQuery {
    DbUpdate() {
    }

    @Transactional
    public KeyHolder update(String sql, SqlParameterSource paramSource, KeyHolder generatedKeyHolder) {
        this.namedParameterJdbcTemplate.update(sql, paramSource, generatedKeyHolder);
        return generatedKeyHolder;
    }

    @Transactional
    public Long update(String sql, SqlParameterSource paramSource) {
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        long updateRowsNumber = this.namedParameterJdbcTemplate.update(sql.toString(), paramSource, (KeyHolder)generatedKeyHolder);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        return generatedKeyHolder.getKey().longValue();
    }

    @Transactional
    public long update(String sql, JSONObject paramJson) {
        return this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
    }

    @Transactional
    public void update(String sql, JSONObject paramJson, int expectedValue, DbExpectedValueModeEnum dBExpectedValueModeEnum) {
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        if (DbExpectedValueModeEnum.EQUAL == dBExpectedValueModeEnum) {
            this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        } else if (DbExpectedValueModeEnum.GREATER_THAN_EQUAL == dBExpectedValueModeEnum) {
            this.updateAndExpectedGreaterThanEqual(updateRowsNumber, expectedValue);
        }
    }

    @Transactional
    public int[] updateBatch(String sql, JSONObject[] paramJsons) {
        return this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons);
    }

    private String updateSqlBuild(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        return this.dialect.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
    }

    @Transactional
    public Long update(String tableName, JSONObject paramJson, String[] conditions) {
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, DbUpdateEnum.NORMAL);
        return this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
    }

    @Transactional
    public Long update(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
        return this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
    }

    @Transactional
    public void update(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum, int expectedValue, DbExpectedValueModeEnum dBExpectedValueModeEnum) {
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        if (DbExpectedValueModeEnum.EQUAL == dBExpectedValueModeEnum) {
            this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        } else if (DbExpectedValueModeEnum.GREATER_THAN_EQUAL == dBExpectedValueModeEnum) {
            this.updateAndExpectedGreaterThanEqual(updateRowsNumber, expectedValue);
        }
    }

    @Transactional
    public void updateById(String tableName, JSONObject paramJson) {
        this.updateById(tableName, paramJson, DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void updateById(String tableName, JSONObject paramJson, DbUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{"id"};
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
    }

    @Transactional
    public void updateById(String tableName, JSONObject[] paramJsons, DbUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{"id"};
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dBUpdateEnum);
        int[] updateRowsNumberArray = this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }

    @Transactional
    public void updateByBusinessUk(String tableName, JSONObject paramJson) {
        this.updateByBusinessUk(tableName, paramJson, DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void updateByBusinessUk(String tableName, JSONObject paramJson, DbUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{this.businessUk};
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
        int updateRowsNumber = this.namedParameterJdbcTemplate.update(sql, (Map)paramJson);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
    }

    @Transactional
    public void updateByBusinessUk(String tableName, JSONObject[] paramJsons, DbUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{this.businessUk};
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dBUpdateEnum);
        int[] updateRowsNumberArray = this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }

    @Transactional
    public void updateSort(String tableName, Long id, Integer move, String ... uniqueKeys) {
        int i;
        this.paramValidate(tableName);
        if (move == 0) {
            throw new DbException("move <= 0");
        }
        String id_key = "id";
        String sort_idx_key = "sort_idx";
        JSONObject sortJson = this.getById(tableName, id);
        int sortIdx = sortJson.getInteger(sort_idx_key);
        int updateSortIdx = sortIdx + move;
        if (updateSortIdx < 1) {
            throw new DbException("\u6392\u5e8f\u540e\u7684\u7d22\u5f15\u503c\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        ArrayList<Integer> updateSortList = new ArrayList<Integer>();
        boolean isASC = false;
        if (updateSortIdx > sortIdx) {
            isASC = true;
            for (i = updateSortIdx; i > sortIdx; --i) {
                updateSortList.add(i);
            }
        } else {
            for (i = updateSortIdx; i < sortIdx; ++i) {
                updateSortList.add(i);
            }
        }
        JSONObject paramJson = new JSONObject();
        if (ArrayUtil.isNotEmpty((Object[])uniqueKeys)) {
            for (String uniqueKey : uniqueKeys) {
                Object uniqueValue = sortJson.get((Object)uniqueKey);
                paramJson.put(uniqueKey, uniqueValue);
            }
        }
        paramJson.put(sort_idx_key, updateSortList);
        List<JSONObject> list = this.list(tableName, paramJson);
        JSONArray paramJsonArray = new JSONArray();
        for (JSONObject actionJSON : list) {
            Long actionId = actionJSON.getLong(id_key);
            Integer actionSort = actionJSON.getInteger(sort_idx_key);
            actionSort = isASC ? Integer.valueOf(actionSort - 1) : Integer.valueOf(actionSort + 1);
            JSONObject actionParamJSON = new JSONObject();
            actionParamJSON.put(id_key, (Object)actionId);
            actionParamJSON.put(sort_idx_key, (Object)actionSort);
            paramJsonArray.add((Object)actionParamJSON);
        }
        JSONObject updateSortParam = new JSONObject();
        updateSortParam.put(id_key, (Object)id);
        updateSortParam.put(sort_idx_key, (Object)updateSortIdx);
        paramJsonArray.add((Object)updateSortParam);
        this.updateById(tableName, ListUtils.toJsons((JSONArray)paramJsonArray), DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void updateBatch(String tableName, JSONObject[] paramJsons, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dBUpdateEnum);
        int[] updateRowsNumberArray = this.namedParameterJdbcTemplate.batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }
}

