/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client.dialect.impl;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.dialect.AnsiSqlDialect;
import ai.yue.library.data.jdbc.client.dialect.DialectName;
import ai.yue.library.data.jdbc.client.dialect.Wrapper;
import ai.yue.library.data.jdbc.constant.DbSortEnum;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import ai.yue.library.data.jdbc.dto.PageDTO;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageBeforeAndAfterVO;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class MysqlDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = -3734718212043823636L;

    public MysqlDialect(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.wrapper = new Wrapper(Character.valueOf('`'));
        this.dialect = this;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    @Override
    public String getPageJoinSql() {
        StringBuffer pageJoinSql = new StringBuffer(" ");
        return pageJoinSql.append("LIMIT").append(" ").append(":page").append(" , ").append(":limit").append(" ").toString();
    }

    @Override
    public DialectName dialectName() {
        return DialectName.MYSQL;
    }

    @Override
    public Long insertOrUpdate(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        String key;
        this.paramValidate(tableName, paramJson, conditions);
        tableName = this.wrapper.wrap(tableName);
        paramJson = this.wrapper.wrap(paramJson);
        conditions = this.wrapper.wrap(conditions);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        sql.append(" (");
        Set keys = paramJson.keySet();
        Iterator it = keys.iterator();
        Iterator iterator = keys.iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            sql.append(key);
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") VALUES (");
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            sql.append(":");
            sql.append(key);
            if (!iterator.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") ON DUPLICATE KEY UPDATE ");
        for (String condition : conditions) {
            sql.append(condition);
            sql.append(" = ");
            if (dBUpdateEnum == DbUpdateEnum.NORMAL) {
                sql.append(":" + condition);
            } else {
                sql.append(condition);
                if (dBUpdateEnum == DbUpdateEnum.INCREMENT) {
                    sql.append(" + :");
                } else {
                    sql.append(" - :");
                }
                sql.append(condition);
            }
            sql.append(", ");
        }
        sql = new StringBuffer(StringUtils.deleteLastEqualString((CharSequence)sql, (CharSequence)", "));
        return this.namedParameterJdbcTemplate.update(sql.toString(), (Map)paramJson);
    }

    @Override
    public PageDTO pageDTOBuild(String tableName, PageIPO pageIPO, DbSortEnum dBSortEnum) {
        this.paramValidate(tableName);
        JSONObject paramJson = this.toParamJson(pageIPO);
        JSONObject conditions = pageIPO.getConditions();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT a.* FROM ");
        querySql.append(tableName + " a, ");
        querySql.append("(SELECT id FROM ");
        querySql.append(tableName);
        String whereSql = "";
        if (conditions != null) {
            whereSql = this.paramToWhereSql(conditions);
        }
        querySql.append(whereSql);
        if (dBSortEnum == null) {
            querySql.append(this.getPageJoinSql()).append(") b WHERE a.id = b.id");
        } else if (DbSortEnum.ASC == dBSortEnum) {
            querySql.append(" ORDER BY ").append("id").append(this.getPageJoinSql()).append(") b WHERE a.id = b.id");
        } else {
            querySql.append(" ORDER BY ").append("id").append(" DESC ").append(this.getPageJoinSql()).append(") b WHERE a.id = b.id");
        }
        StringBuffer countSql = new StringBuffer();
        countSql.append("SELECT COUNT(*) count FROM ");
        countSql.append(tableName);
        countSql.append(whereSql);
        Long count = (Long)this.namedParameterJdbcTemplate.queryForMap(countSql.toString(), (Map)paramJson).get("count");
        return PageDTO.builder().count(count).querySql(querySql.toString()).paramJson(paramJson).build();
    }

    @Override
    public PageDTO pageDTOBuild(String tableName, String whereSql, PageIPO pageIPO) {
        this.paramValidate(tableName, whereSql);
        JSONObject paramJson = this.toParamJson(pageIPO);
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT a.* FROM ");
        querySql.append(tableName + " a, ");
        querySql.append(" (select id from ");
        querySql.append(tableName);
        querySql.append(" ");
        querySql.append(whereSql);
        querySql.append(this.getPageJoinSql()).append(") b WHERE a.id = b.id");
        StringBuffer countSql = new StringBuffer();
        countSql.append("SELECT COUNT(*) count FROM ");
        countSql.append(tableName);
        countSql.append(" ");
        countSql.append(whereSql);
        Long count = (Long)this.namedParameterJdbcTemplate.queryForMap(countSql.toString(), (Map)paramJson).get("count");
        return PageDTO.builder().count(count).querySql(querySql.toString()).paramJson(paramJson).build();
    }

    @Override
    public PageDTO pageDTOBuild(String querySql, PageIPO pageIPO) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DbException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject paramJson = this.toParamJson(pageIPO);
        JSONObject conditions = pageIPO.getConditions();
        int fromIndex = querySql.toUpperCase().indexOf("FROM");
        String countStr = "SELECT count(*) count " + querySql.substring(fromIndex);
        int limitIndex = countStr.toUpperCase().indexOf("LIMIT");
        if (-1 == limitIndex) {
            throw new DbException("querySql\u4e0d\u80fd\u6ca1\u6709LIMIT");
        }
        int EndIndex = countStr.indexOf(")", limitIndex);
        if (-1 == EndIndex) {
            System.err.println("\u9519\u8bef\u7684querySql\uff1a\n");
            System.err.println(querySql);
            throw new DbException("querySql\u5e94\u5f53\u662f\u4e00\u4e2a\u4f18\u5316\u540e\u7684\u8bed\u53e5\uff0c\u5176\u4e2dLIMIT\u5fc5\u987b\u653e\u5728\u5b50\u67e5\u8be2\u5185\uff0c\u8be6\u7ec6\u8bf7\u53c2\u7167\u793a\u4f8b\u8bed\u53e5\u7f16\u5199\u3002");
        }
        StringBuffer countSql = new StringBuffer(countStr);
        countSql = countSql.delete(limitIndex, EndIndex);
        Long count = (Long)this.namedParameterJdbcTemplate.queryForMap(countSql.toString(), (Map)conditions).get("count");
        return PageDTO.builder().count(count).querySql(querySql.toString()).paramJson(paramJson).build();
    }

    @Override
    public PageBeforeAndAfterVO pageBeforeAndAfter(String querySql, PageIPO pageIPO, Long equalsId) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DbException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONArray array = new JSONArray();
        array.addAll((Collection)this.namedParameterJdbcTemplate.queryForList(querySql, (Map)this.toParamJson(pageIPO)));
        int size = array.size();
        Long beforeId = null;
        Long afterId = null;
        String key = "id";
        for (int i = 0; i < size; ++i) {
            JSONObject json = array.getJSONObject(i);
            if (!equalsId.equals(json.getLong(key))) continue;
            if (i != 0) {
                beforeId = array.getJSONObject(i - 1).getLong(key);
            }
            if (i == size - 1) break;
            afterId = array.getJSONObject(i + 1).getLong(key);
            break;
        }
        return PageBeforeAndAfterVO.builder().beforeId(beforeId).afterId(afterId).build();
    }

    @Override
    public String updateSqlBuild(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        this.paramValidate(tableName, paramJson, conditions);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(this.wrapper.wrap(tableName));
        sql.append(" SET ");
        Set keys = paramJson.keySet();
        for (String key : keys) {
            if (ArrayUtil.contains((Object[])conditions, (Object)key)) continue;
            sql.append(this.wrapper.wrap(key));
            sql.append(" = ");
            if (dBUpdateEnum == DbUpdateEnum.INCREMENT) {
                sql.append(this.wrapper.wrap(key));
                sql.append(" + :");
            } else if (dBUpdateEnum == DbUpdateEnum.DECR || dBUpdateEnum == DbUpdateEnum.DECR_UNSIGNED) {
                sql.append(this.wrapper.wrap(key));
                sql.append(" - :");
            } else {
                sql.append(":");
            }
            sql.append(key);
            sql.append(", ");
        }
        sql = new StringBuffer(StringUtils.deleteLastEqualString((CharSequence)sql, (CharSequence)", "));
        String whereSql = this.paramToWhereSql(paramJson, conditions);
        sql.append(whereSql);
        if (dBUpdateEnum == DbUpdateEnum.DECR_UNSIGNED) {
            List updateKeys = MapUtils.keyList((Map)paramJson);
            for (String key : updateKeys) {
                if (ArrayUtil.contains((Object[])conditions, (Object)key)) continue;
                sql.append(" AND ");
                sql.append(this.wrapper.wrap(key));
                sql.append(" >= :");
                sql.append(key);
            }
        }
        return sql.toString();
    }
}

