/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.constant.FieldNamingStrategyEnum;
import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.base.view.ResultPrompt;
import ai.yue.library.data.jdbc.client.dialect.Dialect;
import ai.yue.library.data.jdbc.constant.DbConstant;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class DbBase {
    private static final Logger log = LoggerFactory.getLogger(DbBase.class);
    protected JdbcTemplate jdbcTemplate;
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    protected Dialect dialect;
    String businessUk = "key";
    FieldNamingStrategyEnum databaseFieldNamingStrategy = FieldNamingStrategyEnum.SNAKE_CASE;
    boolean databaseFieldNamingStrategyRecognitionEnabled = true;
    boolean enableDeleteQueryFilter = false;

    public boolean isDataSize(long dataSize) {
        return dataSize > 0L;
    }

    public boolean isUpdateAndExpectedEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber == (long)expectedValue) {
            return true;
        }
        if (updateRowsNumber == 0L) {
            return false;
        }
        String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
        throw new DbException(msg);
    }

    public boolean isUpdateAndExpectedGreaterThanEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber >= (long)expectedValue) {
            return true;
        }
        if (updateRowsNumber == 0L) {
            return false;
        }
        String msg = ResultPrompt.dataStructure((Object)(">= " + expectedValue), (Object)updateRowsNumber);
        throw new DbException(msg);
    }

    public void updateAndExpectedEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber != (long)expectedValue) {
            String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
            throw new DbException(msg);
        }
    }

    public void updateAndExpectedGreaterThanEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber < (long)expectedValue) {
            String msg = ResultPrompt.dataStructure((Object)(">= " + expectedValue), (Object)updateRowsNumber);
            throw new DbException(msg);
        }
    }

    public void updateBatchAndExpectedEqual(int[] updateRowsNumberArray, int expectedValue) {
        for (int updateRowsNumber : updateRowsNumberArray) {
            if (updateRowsNumber == expectedValue) continue;
            Object msg = "\u6267\u884c\u6279\u6b21\u66f4\u65b0\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002";
            msg = (String)msg + ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
            throw new DbException((String)msg);
        }
    }

    public JSONObject resultToJson(List<JSONObject> list) {
        int expectedValue;
        int size = list.size();
        if (size != (expectedValue = 1)) {
            if (size > expectedValue) {
                String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)size);
                log.warn(msg);
            }
            return null;
        }
        return list.get(0);
    }

    public <T> T resultToObject(List<T> list) {
        int expectedValue;
        int size = list.size();
        if (size != (expectedValue = 1)) {
            if (size > expectedValue) {
                String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)size);
                log.warn(msg);
            }
            return null;
        }
        return list.get(0);
    }

    private synchronized void paramToWhereSql(StringBuffer whereSql, JSONObject paramJson, String condition) {
        whereSql.append(" AND ");
        whereSql.append(this.dialect.getWrapper().wrap(condition));
        Object value = paramJson.get((Object)condition);
        if (null == value) {
            whereSql.append(" IS :");
            whereSql.append(condition);
        } else if (value instanceof Collection || ArrayUtil.isArray((Object)value)) {
            whereSql.append(" IN (:");
            whereSql.append(condition);
            whereSql.append(") ");
            if (ArrayUtil.isArray((Object)value)) {
                paramJson.replace((Object)condition, (Object)ListUtils.toList((Object[])((Object[])value)));
            }
        } else {
            whereSql.append(" = :");
            whereSql.append(condition);
        }
    }

    protected String paramToWhereSql(JSONObject paramJson, String ... conditions) {
        StringBuffer whereSql = new StringBuffer();
        whereSql.append(" WHERE 1 = 1 ");
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            for (String condition : conditions) {
                this.paramToWhereSql(whereSql, paramJson, condition);
            }
        }
        return whereSql.toString();
    }

    public String paramToWhereSql(JSONObject paramJson) {
        StringBuffer whereSql = new StringBuffer();
        if (this.enableDeleteQueryFilter) {
            whereSql.append(" WHERE ").append("delete_time").append(" = ").append(DbConstant.FIELD_DEFAULT_VALUE_DELETE_TIME);
        } else {
            whereSql.append(" WHERE 1 = 1 ");
        }
        paramJson.keySet().forEach(condition -> this.paramToWhereSql(whereSql, paramJson, (String)condition));
        return whereSql.toString();
    }

    protected void paramValidate(String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, String whereSql) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("whereSql\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, Long id) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == id) {
            throw new DbException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, String ... columnNames) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])columnNames)) {
            throw new DbException("\u6761\u4ef6\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, Long id, String[] fieldName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == id) {
            throw new DbException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])fieldName)) {
            throw new DbException("fieldName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject paramJson) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmpty((Map)paramJson)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject[] paramJsons) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmptys((Map[])paramJsons)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject paramJson, String[] conditions) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmpty((Map)paramJson)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])conditions) || !MapUtils.isKeys((Map)paramJson, (String[])conditions, (String[])new String[0])) {
            throw new DbException("\u66f4\u65b0\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public String getBusinessUk() {
        return this.businessUk;
    }

    public FieldNamingStrategyEnum getDatabaseFieldNamingStrategy() {
        return this.databaseFieldNamingStrategy;
    }

    public boolean isDatabaseFieldNamingStrategyRecognitionEnabled() {
        return this.databaseFieldNamingStrategyRecognitionEnabled;
    }

    public boolean isEnableDeleteQueryFilter() {
        return this.enableDeleteQueryFilter;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setBusinessUk(String businessUk) {
        this.businessUk = businessUk;
    }

    public void setDatabaseFieldNamingStrategy(FieldNamingStrategyEnum databaseFieldNamingStrategy) {
        this.databaseFieldNamingStrategy = databaseFieldNamingStrategy;
    }

    public void setDatabaseFieldNamingStrategyRecognitionEnabled(boolean databaseFieldNamingStrategyRecognitionEnabled) {
        this.databaseFieldNamingStrategyRecognitionEnabled = databaseFieldNamingStrategyRecognitionEnabled;
    }

    public void setEnableDeleteQueryFilter(boolean enableDeleteQueryFilter) {
        this.enableDeleteQueryFilter = enableDeleteQueryFilter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbBase)) {
            return false;
        }
        DbBase other = (DbBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDatabaseFieldNamingStrategyRecognitionEnabled() != other.isDatabaseFieldNamingStrategyRecognitionEnabled()) {
            return false;
        }
        if (this.isEnableDeleteQueryFilter() != other.isEnableDeleteQueryFilter()) {
            return false;
        }
        JdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        JdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        if (this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate)) {
            return false;
        }
        NamedParameterJdbcTemplate this$namedParameterJdbcTemplate = this.getNamedParameterJdbcTemplate();
        NamedParameterJdbcTemplate other$namedParameterJdbcTemplate = other.getNamedParameterJdbcTemplate();
        if (this$namedParameterJdbcTemplate == null ? other$namedParameterJdbcTemplate != null : !this$namedParameterJdbcTemplate.equals(other$namedParameterJdbcTemplate)) {
            return false;
        }
        Dialect this$dialect = this.getDialect();
        Dialect other$dialect = other.getDialect();
        if (this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect)) {
            return false;
        }
        String this$businessUk = this.getBusinessUk();
        String other$businessUk = other.getBusinessUk();
        if (this$businessUk == null ? other$businessUk != null : !this$businessUk.equals(other$businessUk)) {
            return false;
        }
        FieldNamingStrategyEnum this$databaseFieldNamingStrategy = this.getDatabaseFieldNamingStrategy();
        FieldNamingStrategyEnum other$databaseFieldNamingStrategy = other.getDatabaseFieldNamingStrategy();
        return !(this$databaseFieldNamingStrategy == null ? other$databaseFieldNamingStrategy != null : !this$databaseFieldNamingStrategy.equals(other$databaseFieldNamingStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DbBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDatabaseFieldNamingStrategyRecognitionEnabled() ? 79 : 97);
        result = result * 59 + (this.isEnableDeleteQueryFilter() ? 79 : 97);
        JdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 43 : $jdbcTemplate.hashCode());
        NamedParameterJdbcTemplate $namedParameterJdbcTemplate = this.getNamedParameterJdbcTemplate();
        result = result * 59 + ($namedParameterJdbcTemplate == null ? 43 : $namedParameterJdbcTemplate.hashCode());
        Dialect $dialect = this.getDialect();
        result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
        String $businessUk = this.getBusinessUk();
        result = result * 59 + ($businessUk == null ? 43 : $businessUk.hashCode());
        FieldNamingStrategyEnum $databaseFieldNamingStrategy = this.getDatabaseFieldNamingStrategy();
        result = result * 59 + ($databaseFieldNamingStrategy == null ? 43 : $databaseFieldNamingStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "DbBase(jdbcTemplate=" + this.getJdbcTemplate() + ", namedParameterJdbcTemplate=" + this.getNamedParameterJdbcTemplate() + ", dialect=" + this.getDialect() + ", businessUk=" + this.getBusinessUk() + ", databaseFieldNamingStrategy=" + this.getDatabaseFieldNamingStrategy() + ", databaseFieldNamingStrategyRecognitionEnabled=" + this.isDatabaseFieldNamingStrategyRecognitionEnabled() + ", enableDeleteQueryFilter=" + this.isEnableDeleteQueryFilter() + ")";
    }
}

