/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client.dialect;

import ai.yue.library.base.util.ArithCompute;
import ai.yue.library.data.jdbc.client.DbBase;
import ai.yue.library.data.jdbc.client.dialect.Dialect;
import ai.yue.library.data.jdbc.client.dialect.DialectName;
import ai.yue.library.data.jdbc.client.dialect.Wrapper;
import ai.yue.library.data.jdbc.ipo.Page;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import com.alibaba.fastjson.JSONObject;

public abstract class AnsiSqlDialect
extends DbBase
implements Dialect {
    private static final long serialVersionUID = 1841162445914907750L;
    protected Wrapper wrapper = new Wrapper();

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public String getPageJoinSql() {
        StringBuffer pageJoinSql = new StringBuffer(" ");
        return pageJoinSql.append("LIMIT").append(" ").append(":limit").append(" ").append(":page").append(" ").toString();
    }

    @Override
    public DialectName dialectName() {
        return DialectName.ANSI;
    }

    @Override
    public Page toPage(PageIPO pageIPO) {
        long page = pageIPO.getPage().intValue();
        int limit = pageIPO.getLimit();
        JSONObject conditions = pageIPO.getConditions();
        if (--page >= 1L) {
            page = (long)ArithCompute.mul((double)page, (double)limit);
        }
        return Page.builder().page(page).limit(limit).conditions(conditions).build();
    }

    @Override
    public JSONObject toParamJson(PageIPO pageIPO) {
        return this.toPage(pageIPO).toParamJson();
    }
}

