/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.data.jdbc.client.DbBase;
import ai.yue.library.data.jdbc.support.ColumnMapRowMapper;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

class DbJdbcTemplate
extends DbBase {
    private static final Logger log = LoggerFactory.getLogger(DbJdbcTemplate.class);

    DbJdbcTemplate() {
    }

    public <T> T jdbcQueryObj(String sql, Class<T> requiredType, Object ... args) {
        try {
            return (T)this.getJdbcTemplate().queryForObject(sql, requiredType, args);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public String jdbcQueryStr(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, String.class, args);
    }

    public Integer jdbcQueryInt(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, Integer.class, args);
    }

    public Long jdbcQueryLong(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, Long.class, args);
    }

    public Double jdbcQueryDouble(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, Double.class, args);
    }

    public BigDecimal jdbcQueryBigDecimal(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, BigDecimal.class, args);
    }

    public Number jdbcQueryNumber(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, Number.class, args);
    }

    public Boolean jdbcQueryBoolean(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, Boolean.class, args);
    }

    public Date jdbcQueryDate(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, Date.class, args);
    }

    public LocalDate jdbcQueryLocalDate(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, LocalDate.class, args);
    }

    public LocalDateTime jdbcQueryLocalDateTime(String sql, Object ... args) {
        return this.jdbcQueryObj(sql, LocalDateTime.class, args);
    }

    public JSONObject jdbcQueryForJson(String sql, Object ... args) {
        List<JSONObject> list = this.jdbcQueryForList(sql, args);
        return this.resultToJson(list);
    }

    public List<JSONObject> jdbcQueryForList(String sql, Object ... args) {
        return this.getJdbcTemplate().query(sql, args, (RowMapper)new ColumnMapRowMapper());
    }
}

