/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.dao;

import ai.yue.library.base.constant.FieldNamingStrategyEnum;
import ai.yue.library.base.constant.SortEnum;
import ai.yue.library.base.convert.Convert;
import ai.yue.library.data.jdbc.client.Db;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageTVO;
import cn.hutool.core.util.ClassUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRepository<T> {
    @Autowired
    protected Db db;
    protected Class<T> mappedClass = ClassUtil.getTypeArgument(this.getClass());
    protected String tableName = this.tableName();

    protected abstract String tableName();

    public Long insert(JSONObject paramJson) {
        return this.db.insert(this.tableName(), paramJson);
    }

    public Long insert(Object paramIPO) {
        if (this.db.getJdbcProperties().isEnableFieldNamingStrategyRecognition()) {
            return this.insert(paramIPO, this.db.getJdbcProperties().getDatabaseFieldNamingStrategy());
        }
        return this.insert(Convert.toJSONObject((Object)paramIPO));
    }

    public Long insert(Object paramIPO, FieldNamingStrategyEnum fieldNamingStrategyEnum) {
        PropertyNamingStrategy propertyNamingStrategy = fieldNamingStrategyEnum.getPropertyNamingStrategy();
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.setPropertyNamingStrategy(propertyNamingStrategy);
        JSONObject paramJson = (JSONObject)JSONObject.toJSON((Object)paramIPO, (SerializeConfig)serializeConfig);
        return this.insert(paramJson);
    }

    public void insertBatch(JSONObject[] paramJsons) {
        this.db.insertBatch(this.tableName(), paramJsons);
    }

    public void delete(Long id) {
        this.db.delete(this.tableName(), id);
    }

    @Deprecated
    public void deleteSafe(Long id) {
        this.db.deleteSafe(this.tableName(), id);
    }

    public void deleteByBusinessUk(String businessUkValue) {
        this.db.deleteByBusinessUk(this.tableName, businessUkValue);
    }

    public void deleteLogicByBusinessUk(String businessUkValue) {
        this.db.deleteLogicByBusinessUk(this.tableName, businessUkValue);
    }

    public void updateById(JSONObject paramJson) {
        this.db.updateById(this.tableName(), paramJson);
    }

    public void updateByBusinessUk(JSONObject paramJson) {
        this.db.updateByBusinessUk(this.tableName(), paramJson);
    }

    public T get(Long id) {
        return (T)this.db.getById(this.tableName(), id, (Class)this.mappedClass);
    }

    public T getByBusinessUk(String businessUkValue) {
        return (T)this.db.getByBusinessUk(this.tableName(), businessUkValue, (Class)this.mappedClass);
    }

    public List<T> listAll() {
        return this.db.listAll(this.tableName(), (Class)this.mappedClass);
    }

    public PageTVO<T> page(PageIPO pageIPO) {
        return this.db.page(this.tableName(), pageIPO, (Class)this.mappedClass);
    }

    public PageTVO<T> pageDESC(PageIPO pageIPO) {
        return this.db.page(this.tableName(), pageIPO, (Class)this.mappedClass, SortEnum.DESC);
    }
}

