/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.support;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class ColumnMapRowMapper
implements RowMapper<JSONObject> {
    public JSONObject mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        JSONObject mapOfColumnValues = this.createColumnMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)i);
            mapOfColumnValues.putIfAbsent((Object)this.getColumnKey(column), this.getColumnValue(rs, i));
        }
        return mapOfColumnValues;
    }

    protected JSONObject createColumnMap(int columnCount) {
        return new JSONObject((Map)new LinkedCaseInsensitiveMap(columnCount));
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    @Nullable
    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index);
    }
}

