/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client.dialect.impl;

import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.dialect.Dialect;
import ai.yue.library.data.jdbc.client.dialect.DialectNameEnum;
import ai.yue.library.data.jdbc.client.dialect.Wrapper;
import ai.yue.library.data.jdbc.client.dialect.impl.AnsiDialect;
import ai.yue.library.data.jdbc.config.properties.JdbcProperties;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class PostgresqlDialect
extends AnsiDialect {
    private static final Logger log = LoggerFactory.getLogger(PostgresqlDialect.class);
    private static final long serialVersionUID = 3889210427543389642L;

    public PostgresqlDialect(NamedParameterJdbcTemplate namedParameterJdbcTemplate, JdbcProperties jdbcProperties) {
        super(namedParameterJdbcTemplate, jdbcProperties);
        this.wrapper = new Wrapper(Character.valueOf('\"'));
        this.dialect = this;
    }

    @Override
    public Dialect cloneDialect() {
        return this.clone();
    }

    @Override
    public PostgresqlDialect clone() {
        log.info("\u6267\u884c{}\uff0c\u6df1\u5ea6\u514b\u9686\u3002", this.getClass());
        DataSource dataSource = (DataSource)ObjectUtils.cloneIfPossible((Object)this.getNamedParameterJdbcTemplate().getJdbcTemplate().getDataSource());
        return new PostgresqlDialect(new NamedParameterJdbcTemplate(dataSource), this.jdbcProperties.clone());
    }

    @Override
    public DialectNameEnum dialectName() {
        return DialectNameEnum.POSTGRESQL;
    }

    @Override
    public String getPageJoinSql() {
        return new StringBuffer().append(" ").append("LIMIT").append(" ").append(":limit").append(" ").append("OFFSET").append(" ").append(":page").append(" ").toString();
    }

    @Override
    public Long insertOrUpdate(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        String key;
        this.paramValidate(tableName, paramJson, conditions);
        this.paramFormat(paramJson);
        tableName = this.wrapper.wrap(tableName);
        paramJson = this.wrapper.wrap(paramJson);
        conditions = this.wrapper.wrap(conditions);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        sql.append(" (");
        Set keys = paramJson.keySet();
        Iterator it = keys.iterator();
        Iterator iterator = keys.iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            sql.append(key);
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") VALUES (");
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            sql.append(":");
            sql.append(key);
            if (!iterator.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") ON DUPLICATE KEY UPDATE ");
        for (String condition : conditions) {
            sql.append(condition);
            sql.append(" = ");
            if (dBUpdateEnum == DbUpdateEnum.NORMAL) {
                sql.append(":" + condition);
            } else {
                sql.append(condition);
                if (dBUpdateEnum == DbUpdateEnum.INCREMENT) {
                    sql.append(" + :");
                } else {
                    sql.append(" - :");
                }
                sql.append(condition);
            }
            sql.append(", ");
        }
        sql = new StringBuffer(StringUtils.deleteLastEqualString((CharSequence)sql, (CharSequence)", "));
        return this.namedParameterJdbcTemplate.update(sql.toString(), (Map)paramJson);
    }
}

