/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.config;

import ai.yue.library.data.jdbc.client.Db;
import ai.yue.library.data.jdbc.client.dialect.impl.AnsiDialect;
import ai.yue.library.data.jdbc.client.dialect.impl.DmDialect;
import ai.yue.library.data.jdbc.client.dialect.impl.MysqlDialect;
import ai.yue.library.data.jdbc.client.dialect.impl.PostgresqlDialect;
import ai.yue.library.data.jdbc.config.properties.JdbcProperties;
import com.alibaba.druid.DbType;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

@Configuration
@AutoConfigureAfter(value={JdbcTemplateAutoConfiguration.class})
@EnableConfigurationProperties(value={JdbcProperties.class})
public class JdbcAutoConfig {
    @Bean
    @Primary
    @ConditionalOnBean(value={NamedParameterJdbcTemplate.class})
    public Db db(NamedParameterJdbcTemplate namedParameterJdbcTemplate, JdbcProperties jdbcProperties) {
        String dbType;
        DataSource dataSource = namedParameterJdbcTemplate.getJdbcTemplate().getDataSource();
        DruidDataSource druidDataSource = null;
        try {
            druidDataSource = dataSource instanceof DruidDataSource ? (DruidDataSource)dataSource : (DruidDataSource)((DruidPooledConnection)dataSource.getConnection()).getConnectionHolder().getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        AnsiDialect dialect = druidDataSource != null ? (DbType.mysql.equals(dbType = druidDataSource.getDbType()) ? new MysqlDialect(namedParameterJdbcTemplate, jdbcProperties) : (DbType.postgresql.equals(dbType) ? new PostgresqlDialect(namedParameterJdbcTemplate, jdbcProperties) : (DbType.dm.equals(dbType) ? new DmDialect(namedParameterJdbcTemplate, jdbcProperties) : new AnsiDialect(namedParameterJdbcTemplate, jdbcProperties)))) : new AnsiDialect(namedParameterJdbcTemplate, jdbcProperties);
        return new Db(dialect);
    }
}

