/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.support;

import ai.yue.library.base.util.MapUtils;
import ai.yue.library.data.jdbc.client.DbBase;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class ColumnMapRowMapper
implements RowMapper<JSONObject> {
    private DbBase dbBase;
    @Nullable
    private String[] tableNames;

    public ColumnMapRowMapper(DbBase dbBase, String ... tableNames) {
        this.dbBase = dbBase;
        this.tableNames = tableNames;
    }

    public JSONObject mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        JSONObject resultJson = this.createColumnMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)i);
            resultJson.putIfAbsent((Object)this.getColumnKey(column), this.getColumnValue(rs, i));
        }
        if (ArrayUtil.isNotEmpty((Object[])this.tableNames) && MapUtils.isNotEmpty((Map)resultJson)) {
            this.dbBase.aopAfter(this.tableNames, resultJson);
        }
        return resultJson;
    }

    protected JSONObject createColumnMap(int columnCount) {
        return new JSONObject((Map)new LinkedCaseInsensitiveMap(columnCount));
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    @Nullable
    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index);
    }
}

