/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.data.jdbc.client.DbBase;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DbJdbcTemplate
extends DbBase {
    private static final Logger log = LoggerFactory.getLogger(DbJdbcTemplate.class);

    DbJdbcTemplate() {
    }

    public List<JSONObject> jdbcQueryForList(String sql, Object ... args) {
        return this.jdbcQueryForList(sql, null, args);
    }

    public <T> List<T> jdbcQueryForList(String sql, Class<T> mappedClass, Object ... args) {
        String[] tables = this.extractTables(sql);
        return this.getJdbcTemplate().query(sql, this.getRowMapper(mappedClass, this, tables), args);
    }

    public JSONObject jdbcQueryForJson(String sql, Object ... args) {
        return (JSONObject)this.jdbcQueryForObj(sql, null, args);
    }

    public <T> T jdbcQueryForObj(String sql, Class<T> mappedClass, Object ... args) {
        List<T> list = this.jdbcQueryForList(sql, mappedClass, args);
        return this.listResultToGetResult(list);
    }

    public String jdbcQueryStr(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, String.class, args);
    }

    public Integer jdbcQueryInt(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, Integer.class, args);
    }

    public Long jdbcQueryLong(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, Long.class, args);
    }

    public Double jdbcQueryDouble(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, Double.class, args);
    }

    public BigDecimal jdbcQueryBigDecimal(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, BigDecimal.class, args);
    }

    public Number jdbcQueryNumber(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, Number.class, args);
    }

    public Boolean jdbcQueryBoolean(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, Boolean.class, args);
    }

    public Date jdbcQueryDate(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, Date.class, args);
    }

    public LocalDate jdbcQueryLocalDate(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, LocalDate.class, args);
    }

    public LocalDateTime jdbcQueryLocalDateTime(String sql, Object ... args) {
        return this.jdbcQueryForObj(sql, LocalDateTime.class, args);
    }
}

