/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.constant.SortEnum;
import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.DbJdbcTemplate;
import ai.yue.library.data.jdbc.ipo.Page;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageBeforeAndAfterVO;
import ai.yue.library.data.jdbc.vo.PageVO;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.lang.Nullable;

class DbQuery
extends DbJdbcTemplate {
    private static final Logger log = LoggerFactory.getLogger(DbQuery.class);

    DbQuery() {
    }

    public boolean isExistData(String tableName, JSONObject paramJson) {
        this.paramValidate(tableName, paramJson);
        this.aopBefore(null, tableName, paramJson);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT count(*) FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        String whereSql = this.paramToWhereSql(paramJson);
        sql.append(whereSql);
        Long count = this.queryForObject(sql.toString(), paramJson, Long.class);
        return count > 0L;
    }

    private String querySqlBuild(String tableName, JSONObject paramJson, SortEnum sortEnum) {
        this.paramValidate(tableName, paramJson);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        String whereSql = this.paramToWhereSql(paramJson);
        sql.append(whereSql);
        if (sortEnum == SortEnum.ASC) {
            sql.append(" ORDER BY id");
        } else if (sortEnum == SortEnum.DESC) {
            sql.append(" ORDER BY id DESC");
        }
        return sql.toString();
    }

    private String getByColumnNameSqlBuild(String tableName, String columnName) {
        this.paramValidate(tableName);
        if (StringUtils.isEmpty((CharSequence)columnName)) {
            throw new DbException("\u6761\u4ef6\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        tableName = this.dialect.getWrapper().wrap(tableName);
        columnName = this.dialect.getWrapper().wrap(columnName);
        StringBuffer sql = new StringBuffer("SELECT * FROM ");
        sql.append(tableName);
        sql.append(this.getDeleteWhereSql());
        sql.append(" AND ").append(columnName).append(" = :").append(columnName);
        return sql.toString();
    }

    public SqlRowSetMetaData getMetaData(String tableName) {
        tableName = this.dialect.getWrapper().wrap(tableName);
        StringBuffer sql = new StringBuffer("SELECT * FROM ").append(tableName).append(this.dialect.getPageJoinSql());
        return this.queryForRowSet(sql.toString(), Page.builder().page(0L).limit(0).build().toParamJson()).getMetaData();
    }

    public long getCount(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT count(*) count FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        sql.append(this.getDeleteWhereSql());
        return this.queryForObject(sql.toString(), null, Long.class);
    }

    public JSONObject getById(String tableName, long id) {
        return (JSONObject)this.getById(tableName, id, null);
    }

    public <T> T getById(String tableName, Long id, Class<T> mappedClass) {
        this.paramValidate(tableName, id);
        String sql = this.getByColumnNameSqlBuild(tableName, "id");
        JSONObject paramJson = new JSONObject();
        paramJson.put(this.dialect.getWrapper().wrap("id"), (Object)id);
        return this.queryForObject(sql, paramJson, mappedClass);
    }

    public JSONObject getByBusinessUk(String tableName, String businessUkValue) {
        return (JSONObject)this.getByBusinessUk(tableName, businessUkValue, null);
    }

    public <T> T getByBusinessUk(String tableName, String businessUkValue, Class<T> mappedClass) {
        String sql = this.getByColumnNameSqlBuild(tableName, this.getJdbcProperties().getBusinessUk());
        JSONObject paramJson = new JSONObject();
        paramJson.put(this.dialect.getWrapper().wrap(this.getJdbcProperties().getBusinessUk()), (Object)businessUkValue);
        return this.queryForObject(sql, paramJson, mappedClass);
    }

    public JSONObject get(String tableName, JSONObject paramJson) {
        return (JSONObject)this.get(tableName, paramJson, null);
    }

    public <T> T get(String tableName, JSONObject paramJson, Class<T> mappedClass) {
        this.paramFormat(paramJson);
        this.aopBefore(null, tableName, paramJson);
        String sql = this.querySqlBuild(tableName, paramJson, null);
        return this.queryForObject(sql, paramJson, mappedClass);
    }

    public List<JSONObject> list(String tableName, JSONObject paramJson) {
        return this.list(tableName, paramJson, (Class)null);
    }

    public <T> List<T> list(String tableName, JSONObject paramJson, Class<T> mappedClass) {
        this.paramFormat(paramJson);
        this.aopBefore(null, tableName, paramJson);
        String sql = this.querySqlBuild(tableName, paramJson, null);
        return this.queryForList(sql, paramJson, mappedClass);
    }

    public List<JSONObject> list(String tableName, JSONObject paramJson, SortEnum sortEnum) {
        return this.list(tableName, paramJson, sortEnum, null);
    }

    public <T> List<T> list(String tableName, JSONObject paramJson, SortEnum sortEnum, Class<T> mappedClass) {
        this.paramFormat(paramJson);
        this.aopBefore(null, tableName, paramJson);
        String sql = this.querySqlBuild(tableName, paramJson, sortEnum);
        return this.queryForList(sql, paramJson, mappedClass);
    }

    public List<JSONObject> listAll(String tableName) {
        return this.listAll(tableName, null);
    }

    public <T> List<T> listAll(String tableName, Class<T> mappedClass) {
        this.paramValidate(tableName);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        sql.append(this.getDeleteWhereSql());
        return this.queryForList(sql.toString(), MapUtils.FINAL_EMPTY_JSON, mappedClass);
    }

    public PageVO<JSONObject> page(String tableName, PageIPO pageIPO) {
        return this.page(tableName, pageIPO, (Class)null);
    }

    public <T> PageVO<T> page(String tableName, PageIPO pageIPO, Class<T> mappedClass) {
        this.paramFormat(pageIPO.getConditions());
        return this.dialect.page(tableName, pageIPO, null, mappedClass);
    }

    public PageVO<JSONObject> page(String tableName, PageIPO pageIPO, SortEnum sortEnum) {
        return this.page(tableName, pageIPO, sortEnum, null);
    }

    public <T> PageVO<T> page(String tableName, PageIPO pageIPO, SortEnum sortEnum, Class<T> mappedClass) {
        this.paramFormat(pageIPO.getConditions());
        return this.dialect.page(tableName, pageIPO, sortEnum, mappedClass);
    }

    public PageVO<JSONObject> pageWhere(String tableName, String whereSql, PageIPO pageIPO) {
        return this.pageWhere(tableName, whereSql, pageIPO, null);
    }

    public <T> PageVO<T> pageWhere(String tableName, String whereSql, PageIPO pageIPO, Class<T> mappedClass) {
        return this.dialect.pageWhere(tableName, whereSql, pageIPO, mappedClass);
    }

    public PageVO<JSONObject> pageSql(String querySql, PageIPO pageIPO) {
        return this.pageSql(querySql, pageIPO, null);
    }

    public <T> PageVO<T> pageSql(String querySql, PageIPO pageIPO, Class<T> mappedClass) {
        return this.dialect.pageSql(querySql, pageIPO, mappedClass);
    }

    public PageVO<JSONObject> pageSql(@Nullable String countSql, String querySql, PageIPO pageIPO) {
        return this.pageSql(countSql, querySql, pageIPO, null);
    }

    public <T> PageVO<T> pageSql(@Nullable String countSql, String querySql, PageIPO pageIPO, Class<T> mappedClass) {
        return this.dialect.pageSql(countSql, querySql, pageIPO, mappedClass);
    }

    public PageBeforeAndAfterVO pageBeforeAndAfter(String querySql, PageIPO pageIPO, Long equalsId) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DbException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONArray array = new JSONArray();
        array.addAll(this.queryForList(querySql, this.dialect.toPage(pageIPO).toParamJson()));
        int size = array.size();
        Long beforeId = null;
        Long afterId = null;
        String key = "id";
        for (int i = 0; i < size; ++i) {
            JSONObject json = array.getJSONObject(i);
            if (!equalsId.equals(json.getLong(key))) continue;
            if (i != 0) {
                beforeId = array.getJSONObject(i - 1).getLong(key);
            }
            if (i == size - 1) break;
            afterId = array.getJSONObject(i + 1).getLong(key);
            break;
        }
        return PageBeforeAndAfterVO.builder().beforeId(beforeId).afterId(afterId).build();
    }
}

