/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.dao;

import ai.yue.library.data.jdbc.client.Db;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageVO;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AbstractBaseDAO<T> {
    @Autowired
    protected Db db;
    protected String tableName = this.tableName();

    AbstractBaseDAO() {
    }

    protected abstract String tableName();

    public Long insert(JSONObject paramJson) {
        return this.db.insert(this.tableName(), paramJson);
    }

    public void insertBatch(JSONObject[] paramJsons) {
        this.db.insertBatch(this.tableName(), paramJsons);
    }

    public void delete(Long id) {
        this.db.delete(this.tableName(), id);
    }

    public void deleteLogic(Long id) {
        this.db.deleteLogic(this.tableName(), id);
    }

    public void deleteByBusinessUk(String businessUkValue) {
        this.db.deleteByBusinessUk(this.tableName, businessUkValue);
    }

    public void deleteLogicByBusinessUk(String businessUkValue) {
        this.db.deleteLogicByBusinessUk(this.tableName, businessUkValue);
    }

    public void updateById(JSONObject paramJson) {
        this.db.updateById(this.tableName(), paramJson);
    }

    public void updateByBusinessUk(JSONObject paramJson) {
        this.db.updateByBusinessUk(this.tableName(), paramJson);
    }

    public abstract T get(Long var1);

    public abstract T getByBusinessUk(String var1);

    public abstract List<T> listAll();

    public abstract PageVO<T> page(PageIPO var1);

    public abstract PageVO<T> pageDESC(PageIPO var1);
}

