/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.data.jdbc.client.DbUpdate;
import ai.yue.library.data.jdbc.constant.CrudEnum;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;

class DbDelete
extends DbUpdate {
    DbDelete() {
    }

    private String deleteSqlBuild(String tableName, JSONObject paramJson) {
        this.paramValidate(tableName, paramJson);
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        sql.append(this.paramToWhereSqlNotDeleteWhere(paramJson));
        return sql.toString();
    }

    private void deleteByPk(String tableName, Object pkValue) {
        this.paramValidate(tableName);
        if (ObjectUtils.isNull((Object)pkValue)) {
            throw new DbException("\u5220\u9664\u6761\u4ef6\u4e0d\u80fd\u4e3anull");
        }
        JSONObject data = null;
        String pkName = null;
        try {
            if (pkValue instanceof Long) {
                data = this.getById(tableName, (Long)pkValue);
                pkName = "id";
            } else if (pkValue instanceof String) {
                data = this.getByUuid(tableName, (String)pkValue);
                pkName = this.getJdbcProperties().getFieldDefinitionUuid();
            }
        }
        catch (Exception e) {
            data = null;
        }
        if (data == null || data.isEmpty()) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u5f02\u5e38\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5b58\u5728\u591a\u6761\u6570\u636e", true);
        }
        JSONObject paramJson = new JSONObject();
        paramJson.put(pkName, pkValue);
        String sql = this.deleteSqlBuild(tableName, paramJson);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        if (updateRowsNumber != 1) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public long delete(String tableName, JSONObject paramJson) {
        this.paramFormat(paramJson);
        this.dataEncrypt(tableName, paramJson);
        String sql = this.deleteSqlBuild(tableName, paramJson);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteById(String tableName, Long id) {
        this.deleteByPk(tableName, id);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteByUuid(String tableName, String uuidValue) {
        this.deleteByPk(tableName, uuidValue);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteBatch(String tableName, JSONObject[] paramJsons) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.deleteBatchNotParamFormat(tableName, paramJsons);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteBatchNotParamFormat(String tableName, JSONObject[] paramJsons) {
        int[] updateRowsNumberArray;
        String sql = this.deleteSqlBuild(tableName, paramJsons[0]);
        this.dataEncrypt(tableName, paramJsons);
        for (int updateRowsNumber : updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons)) {
            if (updateRowsNumber <= 1) continue;
            throw new DbException("\u6267\u884c\u6279\u6b21\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public int[] deleteBatch2(String sql, JSONObject[] paramJsons) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        return this.deleteBatchNotParamFormat2(sql, paramJsons);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public int[] deleteBatchNotParamFormat2(String sql, JSONObject[] paramJsons) {
        this.dataEncryptExtractTable(sql, paramJsons);
        return this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
    }

    private String deleteLogicSqlBuild(String tableName, JSONObject paramJson, @Nullable JSONObject auditUpdateJson) {
        this.paramValidate(tableName, paramJson);
        String[] conditions = new String[paramJson.size()];
        conditions = paramJson.keySet().toArray(conditions);
        if (MapUtils.isEmpty((Map)auditUpdateJson)) {
            paramJson.put(this.getJdbcProperties().getFieldDefinitionDeleteTime(), (Object)System.currentTimeMillis());
        } else {
            paramJson.putAll((Map)auditUpdateJson);
        }
        return this.updateSqlBuild(tableName, paramJson, conditions, DbUpdateEnum.NORMAL);
    }

    private void deleteLogicByUk(String tableName, Object pkValue) {
        this.paramValidate(tableName);
        if (ObjectUtils.isNull((Object)pkValue)) {
            throw new DbException("\u5220\u9664\u6761\u4ef6\u4e0d\u80fd\u4e3anull");
        }
        String pkName = null;
        if (pkValue instanceof Long) {
            pkName = "id";
        } else if (pkValue instanceof String) {
            pkName = this.getJdbcProperties().getFieldDefinitionUuid();
        }
        JSONObject paramJson = new JSONObject();
        paramJson.put(pkName, pkValue);
        JSONObject auditParam = new JSONObject();
        this.dataAudit(tableName, CrudEnum.D, auditParam);
        String sql = this.deleteLogicSqlBuild(tableName, paramJson, auditParam);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        if (updateRowsNumber != 1) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public long deleteLogic(String tableName, JSONObject paramJson) {
        this.paramFormat(paramJson);
        this.dataEncrypt(tableName, paramJson);
        JSONObject auditParam = new JSONObject();
        this.dataAudit(tableName, CrudEnum.D, auditParam);
        String sql = this.deleteLogicSqlBuild(tableName, paramJson, auditParam);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteLogicById(String tableName, Long id) {
        this.deleteLogicByUk(tableName, id);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteLogicByUuid(String tableName, String uuidValue) {
        this.deleteLogicByUk(tableName, uuidValue);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteBatchLogic(String tableName, JSONObject[] paramJsons) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.deleteBatchLogicNotParamFormat(tableName, paramJsons);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteBatchLogicNotParamFormat(String tableName, JSONObject[] paramJsons) {
        int[] updateRowsNumberArray;
        JSONObject[] auditUpdateJsons = new JSONObject[paramJsons.length];
        for (int i = 0; i < auditUpdateJsons.length; ++i) {
            auditUpdateJsons[i] = new JSONObject();
        }
        this.dataAudit(tableName, CrudEnum.D, auditUpdateJsons);
        String sql = this.deleteLogicSqlBuild(tableName, paramJsons[0], auditUpdateJsons[0]);
        if (MapUtils.isNotEmpty((Map)auditUpdateJsons[0])) {
            for (int i = 1; i < paramJsons.length; ++i) {
                paramJsons[i].putAll((Map)auditUpdateJsons[i]);
            }
        }
        this.dataEncrypt(tableName, paramJsons);
        for (int updateRowsNumber : updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons)) {
            if (updateRowsNumber <= 1) continue;
            throw new DbException("\u6267\u884c\u6279\u6b21\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }
}

