/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.DbQuery;
import ai.yue.library.data.jdbc.constant.CrudEnum;
import ai.yue.library.data.jdbc.constant.DbExpectedEnum;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import ai.yue.library.data.jdbc.provider.FillDataProvider;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.transaction.annotation.Transactional;

class DbUpdate
extends DbQuery {
    DbUpdate() {
    }

    @Transactional
    public Long update(String sql, SqlParameterSource paramSource) {
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        long updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, paramSource, (KeyHolder)generatedKeyHolder);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        return generatedKeyHolder.getKey().longValue();
    }

    @Transactional
    public long update(String sql, JSONObject paramJson) {
        this.paramFormat(paramJson);
        this.dataEncryptExtractTable(sql, paramJson);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional
    public void update(String sql, JSONObject paramJson, int expectedValue, DbExpectedEnum dbExpectedEnum) {
        long updateRowsNumber = this.update(sql, paramJson);
        if (DbExpectedEnum.EQ == dbExpectedEnum) {
            this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        } else if (DbExpectedEnum.GE == dbExpectedEnum) {
            this.updateAndExpectedGreaterThanEqual(updateRowsNumber, expectedValue);
        }
    }

    @Transactional
    public int[] updateBatch(String sql, JSONObject[] paramJsons) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        return this.updateBatchNotParamFormat(sql, paramJsons);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public int[] updateBatchNotParamFormat(String sql, JSONObject[] paramJsons) {
        this.dataEncryptExtractTable(sql, paramJsons);
        return this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
    }

    protected String updateSqlBuild(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dbUpdateEnum) {
        this.paramValidate(tableName, paramJson, conditions);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        sql.append(" SET ");
        Set keys = paramJson.keySet();
        for (String key : keys) {
            if (ArrayUtil.contains((Object[])conditions, (Object)key)) continue;
            sql.append(this.dialect.getWrapper().wrap(key));
            sql.append(" = ");
            if (dbUpdateEnum == DbUpdateEnum.INCREMENT) {
                sql.append(this.dialect.getWrapper().wrap(key));
                sql.append(" + :");
            } else if (dbUpdateEnum == DbUpdateEnum.DECR || dbUpdateEnum == DbUpdateEnum.DECR_UNSIGNED) {
                sql.append(this.dialect.getWrapper().wrap(key));
                sql.append(" - :");
            } else {
                sql.append(":");
            }
            sql.append(key);
            sql.append(", ");
        }
        sql = new StringBuffer(StringUtils.deleteLastEqualString((CharSequence)sql, (CharSequence)", "));
        String whereSql = this.paramToWhereSql(paramJson, conditions);
        sql.append(whereSql);
        if (dbUpdateEnum == DbUpdateEnum.DECR_UNSIGNED) {
            List updateKeys = MapUtils.keyList((Map)paramJson);
            for (String key : updateKeys) {
                if (ArrayUtil.contains((Object[])conditions, (Object)key)) continue;
                sql.append(" AND ");
                sql.append(this.dialect.getWrapper().wrap(key));
                sql.append(" >= :");
                sql.append(key);
            }
        }
        return sql.toString();
    }

    @Transactional
    public Long update(String tableName, JSONObject paramJson, String[] conditions) {
        this.paramFormat(paramJson);
        this.dataEncrypt(tableName, paramJson);
        this.dataAudit(tableName, CrudEnum.U, paramJson);
        paramJson.putAll((Map)FillDataProvider.getUpdateParamJson(this.getJdbcProperties(), tableName));
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, DbUpdateEnum.NORMAL);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional
    public Long update(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dbUpdateEnum) {
        this.paramFormat(paramJson);
        this.dataEncrypt(tableName, paramJson);
        this.dataAudit(tableName, CrudEnum.U, paramJson);
        paramJson.putAll((Map)FillDataProvider.getUpdateParamJson(this.getJdbcProperties(), tableName));
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dbUpdateEnum);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional
    public void update(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dbUpdateEnum, int expectedValue, DbExpectedEnum dbExpectedEnum) {
        this.paramFormat(paramJson);
        this.dataEncrypt(tableName, paramJson);
        this.dataAudit(tableName, CrudEnum.U, paramJson);
        paramJson.putAll((Map)FillDataProvider.getUpdateParamJson(this.getJdbcProperties(), tableName));
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dbUpdateEnum);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        if (DbExpectedEnum.EQ == dbExpectedEnum) {
            this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        } else if (DbExpectedEnum.GE == dbExpectedEnum) {
            this.updateAndExpectedGreaterThanEqual(updateRowsNumber, expectedValue);
        }
    }

    @Transactional
    public void updateById(String tableName, JSONObject paramJson) {
        this.updateById(tableName, paramJson, DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void updateById(String tableName, JSONObject paramJson, DbUpdateEnum dbUpdateEnum) {
        String[] conditions = new String[]{"id"};
        this.paramFormat(paramJson);
        this.dataEncrypt(tableName, paramJson);
        this.dataAudit(tableName, CrudEnum.U, paramJson);
        paramJson.putAll((Map)FillDataProvider.getUpdateParamJson(this.getJdbcProperties(), tableName));
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dbUpdateEnum);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
    }

    @Transactional
    public void updateById(String tableName, JSONObject[] paramJsons, DbUpdateEnum dbUpdateEnum) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.updateByIdNotParamFormat(tableName, paramJsons, dbUpdateEnum);
    }

    @Transactional
    public void updateByIdNotParamFormat(String tableName, JSONObject[] paramJsons, DbUpdateEnum dbUpdateEnum) {
        String[] conditions = new String[]{"id"};
        this.dataEncrypt(tableName, paramJsons);
        this.dataAudit(tableName, CrudEnum.U, paramJsons);
        for (JSONObject paramJson : paramJsons) {
            paramJson.putAll((Map)FillDataProvider.getUpdateParamJson(this.getJdbcProperties(), tableName));
        }
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dbUpdateEnum);
        int[] updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }

    @Transactional
    public void updateByUuid(String tableName, JSONObject paramJson) {
        this.updateByUuid(tableName, paramJson, DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void updateByUuid(String tableName, JSONObject paramJson, DbUpdateEnum dbUpdateEnum) {
        String[] conditions = new String[]{this.getJdbcProperties().getFieldDefinitionUuid()};
        this.paramFormat(paramJson);
        this.dataEncrypt(tableName, paramJson);
        this.dataAudit(tableName, CrudEnum.U, paramJson);
        paramJson.putAll((Map)FillDataProvider.getUpdateParamJson(this.getJdbcProperties(), tableName));
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dbUpdateEnum);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
    }

    @Transactional
    public void updateByUuid(String tableName, JSONObject[] paramJsons, DbUpdateEnum dbUpdateEnum) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.updateByUuidNotParamFormat(tableName, paramJsons, dbUpdateEnum);
    }

    @Transactional
    public void updateByUuidNotParamFormat(String tableName, JSONObject[] paramJsons, DbUpdateEnum dbUpdateEnum) {
        String[] conditions = new String[]{this.getJdbcProperties().getFieldDefinitionUuid()};
        this.dataEncrypt(tableName, paramJsons);
        this.dataAudit(tableName, CrudEnum.U, paramJsons);
        for (JSONObject paramJson : paramJsons) {
            paramJson.putAll((Map)FillDataProvider.getUpdateParamJson(this.getJdbcProperties(), tableName));
        }
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dbUpdateEnum);
        int[] updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }

    @Transactional
    public void updateSort(String tableName, Long id, Integer move, String ... uniqueKeys) {
        long i;
        this.paramValidate(tableName);
        if (move == 0) {
            throw new DbException("move <= 0");
        }
        JSONObject sortJson = this.getById(tableName, id);
        long sortIdx = sortJson.getLongValue(this.getJdbcProperties().getFieldDefinitionSortIdx());
        long updateSortIdx = sortIdx + (long)move.intValue();
        if (updateSortIdx < 1L) {
            throw new DbException("\u6392\u5e8f\u540e\u7684\u7d22\u5f15\u503c\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        ArrayList<Long> updateSortList = new ArrayList<Long>();
        boolean isASC = false;
        if (updateSortIdx > sortIdx) {
            isASC = true;
            for (i = updateSortIdx; i > sortIdx; --i) {
                updateSortList.add(i);
            }
        } else {
            for (i = updateSortIdx; i < sortIdx; ++i) {
                updateSortList.add(i);
            }
        }
        JSONObject paramJson = new JSONObject();
        if (ArrayUtil.isNotEmpty((Object[])uniqueKeys)) {
            for (String uniqueKey : uniqueKeys) {
                Object uniqueValue = sortJson.get((Object)uniqueKey);
                paramJson.put(uniqueKey, uniqueValue);
            }
        }
        paramJson.put(this.getJdbcProperties().getFieldDefinitionSortIdx(), updateSortList);
        List<JSONObject> list = this.list(tableName, paramJson);
        JSONArray paramJsonArray = new JSONArray();
        for (JSONObject actionJSON : list) {
            Long actionId = actionJSON.getLong("id");
            Long actionSort = actionJSON.getLong(this.getJdbcProperties().getFieldDefinitionSortIdx());
            actionSort = isASC ? Long.valueOf(actionSort - 1L) : Long.valueOf(actionSort + 1L);
            JSONObject actionParamJSON = new JSONObject();
            actionParamJSON.put("id", (Object)actionId);
            actionParamJSON.put(this.getJdbcProperties().getFieldDefinitionSortIdx(), (Object)actionSort);
            paramJsonArray.add((Object)actionParamJSON);
        }
        JSONObject updateSortParam = new JSONObject();
        updateSortParam.put("id", (Object)id);
        updateSortParam.put(this.getJdbcProperties().getFieldDefinitionSortIdx(), (Object)updateSortIdx);
        paramJsonArray.add((Object)updateSortParam);
        this.updateById(tableName, ListUtils.toJsons((JSONArray)paramJsonArray), DbUpdateEnum.NORMAL);
    }

    public void updateBatch(String tableName, JSONObject[] paramJsons, String[] conditions, DbUpdateEnum dbUpdateEnum) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.updateBatchNotParamFormat(tableName, paramJsons, conditions, dbUpdateEnum);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void updateBatchNotParamFormat(String tableName, JSONObject[] paramJsons, String[] conditions, DbUpdateEnum dbUpdateEnum) {
        JSONObject[] auditUpdateJsons = new JSONObject[paramJsons.length];
        for (int i = 0; i < auditUpdateJsons.length; ++i) {
            auditUpdateJsons[i] = new JSONObject();
        }
        this.dataAudit(tableName, CrudEnum.U, auditUpdateJsons);
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dbUpdateEnum);
        if (MapUtils.isNotEmpty((Map)auditUpdateJsons[0])) {
            for (int i = 1; i < paramJsons.length; ++i) {
                paramJsons[i].putAll((Map)auditUpdateJsons[i]);
            }
        }
        this.dataEncrypt(tableName, paramJsons);
        int[] updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }
}

