/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.dao;

import ai.yue.library.base.constant.FieldNamingStrategyEnum;
import ai.yue.library.base.constant.SortEnum;
import ai.yue.library.base.convert.Convert;
import ai.yue.library.data.jdbc.dao.AbstractBaseDAO;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageVO;
import cn.hutool.core.util.ClassUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import java.util.List;

public abstract class AbstractRepository<T>
extends AbstractBaseDAO {
    protected Class<T> mappedClass = ClassUtil.getTypeArgument(this.getClass());

    public Long insert(Object paramIPO) {
        if (this.db.getJdbcProperties().isEnableFieldNamingStrategyRecognition()) {
            return this.insert(paramIPO, this.db.getJdbcProperties().getDatabaseFieldNamingStrategy());
        }
        return this.insert(Convert.toJSONObject((Object)paramIPO));
    }

    public Long insert(Object paramIPO, FieldNamingStrategyEnum fieldNamingStrategyEnum) {
        PropertyNamingStrategy propertyNamingStrategy = fieldNamingStrategyEnum.getPropertyNamingStrategy();
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.setPropertyNamingStrategy(propertyNamingStrategy);
        JSONObject paramJson = (JSONObject)JSONObject.toJSON((Object)paramIPO, (SerializeConfig)serializeConfig);
        return this.insert(paramJson);
    }

    @Override
    public T getById(Long id) {
        return (T)this.db.getById(this.tableName(), id, (Class)this.mappedClass);
    }

    @Override
    public T getByUuid(String uuidValue) {
        return (T)this.db.getByUuid(this.tableName(), uuidValue, (Class)this.mappedClass);
    }

    @Override
    public List<T> listAll() {
        return this.db.listAll(this.tableName(), (Class)this.mappedClass);
    }

    @Override
    public PageVO<T> page(PageIPO pageIPO) {
        return this.db.page(this.tableName(), pageIPO, (Class)this.mappedClass);
    }

    @Override
    public PageVO<T> pageDESC(PageIPO pageIPO) {
        return this.db.page(this.tableName(), pageIPO, SortEnum.DESC, (Class)this.mappedClass);
    }
}

