/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.constant.MatchEnum;
import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ClassUtils;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.base.view.ResultPrompt;
import ai.yue.library.data.jdbc.client.dialect.Dialect;
import ai.yue.library.data.jdbc.config.properties.DataAuditProperties;
import ai.yue.library.data.jdbc.config.properties.DataEncryptProperties;
import ai.yue.library.data.jdbc.config.properties.JdbcProperties;
import ai.yue.library.data.jdbc.constant.CrudEnum;
import ai.yue.library.data.jdbc.constant.DbConstant;
import ai.yue.library.data.jdbc.constant.EncryptAlgorithmEnum;
import ai.yue.library.data.jdbc.provider.AuditUserProvider;
import ai.yue.library.data.jdbc.support.BeanPropertyRowMapper;
import ai.yue.library.data.jdbc.support.ColumnMapRowMapper;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.DbType;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.Nullable;

public class DbBase {
    private static final Logger log = LoggerFactory.getLogger(DbBase.class);
    protected Dialect dialect;
    private static final String IS_PREFIX = "is";
    private static final String IS_PREFIX_FORMAT = "is_%s";

    public DataSource getDataSource() {
        return this.getJdbcTemplate().getDataSource();
    }

    public DruidDataSource getDruidDataSource() {
        DataSource dataSource = this.getDataSource();
        DruidDataSource druidDataSource = null;
        try {
            druidDataSource = dataSource instanceof DruidDataSource ? (DruidDataSource)dataSource : (DruidDataSource)((DruidPooledConnection)dataSource.getConnection()).getConnectionHolder().getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return druidDataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.getJdbcTemplate().setDataSource(dataSource);
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.dialect.getNamedParameterJdbcTemplate();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.getNamedParameterJdbcTemplate().getJdbcTemplate();
    }

    public JdbcProperties getJdbcProperties() {
        return this.dialect.getJdbcProperties();
    }

    public <T> RowMapper<T> getRowMapper(Class<T> mappedClass) {
        Object rowMapper = mappedClass == null || Map.class.isAssignableFrom(mappedClass) ? new ColumnMapRowMapper() : (ClassUtils.isSimpleValueType(mappedClass) ? SingleColumnRowMapper.newInstance(mappedClass) : new BeanPropertyRowMapper<T>(mappedClass, this));
        return rowMapper;
    }

    public <T> T listResultToGetResult(List<T> list) {
        int expectedValue;
        int size = list.size();
        if (size != (expectedValue = 1)) {
            if (size > expectedValue) {
                throw new DbException(ResultPrompt.dataStructure((Object)expectedValue, (Object)size), true);
            }
            return null;
        }
        return list.get(0);
    }

    public JSONObject queryForJson(String sql, @Nullable JSONObject paramJson) {
        return (JSONObject)this.queryForObject(sql, paramJson, null);
    }

    public <T> T queryForObject(String sql, @Nullable JSONObject paramJson, Class<T> mappedClass) {
        List<T> list = this.queryForList(sql, paramJson, mappedClass);
        return this.listResultToGetResult(list);
    }

    public SqlRowSet queryForRowSet(String sql, @Nullable JSONObject paramJson) {
        return this.getNamedParameterJdbcTemplate().queryForRowSet(sql, (Map)paramJson);
    }

    public List<JSONObject> queryForList(String sql, @Nullable JSONObject paramJson) {
        return this.queryForList(sql, paramJson, null);
    }

    public <T> List<T> queryForList(String sql, @Nullable JSONObject paramJson, Class<T> mappedClass) {
        return this.getNamedParameterJdbcTemplate().query(sql, (Map)paramJson, this.getRowMapper(mappedClass));
    }

    public boolean isUpdateAndExpectedEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber == (long)expectedValue) {
            return true;
        }
        if (updateRowsNumber == 0L) {
            return false;
        }
        String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
        throw new DbException(msg);
    }

    public boolean isUpdateAndExpectedGreaterThanEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber >= (long)expectedValue) {
            return true;
        }
        if (updateRowsNumber == 0L) {
            return false;
        }
        String msg = ResultPrompt.dataStructure((Object)(">= " + expectedValue), (Object)updateRowsNumber);
        throw new DbException(msg);
    }

    public void updateAndExpectedEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber != (long)expectedValue) {
            String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
            throw new DbException(msg);
        }
    }

    public void updateAndExpectedGreaterThanEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber < (long)expectedValue) {
            String msg = ResultPrompt.dataStructure((Object)(">= " + expectedValue), (Object)updateRowsNumber);
            throw new DbException(msg);
        }
    }

    public void updateBatchAndExpectedEqual(int[] updateRowsNumberArray, int expectedValue) {
        for (int updateRowsNumber : updateRowsNumberArray) {
            if (updateRowsNumber == expectedValue) continue;
            Object msg = "\u6267\u884c\u6279\u6b21\u66f4\u65b0\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002";
            msg = (String)msg + ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
            throw new DbException((String)msg);
        }
    }

    private synchronized void paramToWhereSql(StringBuffer whereSql, JSONObject paramJson, String condition) {
        whereSql.append(" AND ");
        whereSql.append(this.dialect.getWrapper().wrap(condition));
        Object value = paramJson.get((Object)condition);
        if (null == value) {
            whereSql.append(" IS :");
            whereSql.append(condition);
        } else if (value instanceof Collection || ArrayUtil.isArray((Object)value)) {
            whereSql.append(" IN (:");
            whereSql.append(condition);
            whereSql.append(") ");
            if (ArrayUtil.isArray((Object)value)) {
                paramJson.replace((Object)condition, (Object)ListUtils.toList((Object[])((Object[])value)));
            }
        } else {
            whereSql.append(" = :");
            whereSql.append(condition);
        }
    }

    public String paramToWhereSql(JSONObject paramJson, String ... conditions) {
        StringBuffer whereSql = new StringBuffer(this.getDeleteWhereSql());
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            for (String condition : conditions) {
                this.paramToWhereSql(whereSql, paramJson, condition);
            }
        }
        return whereSql.toString();
    }

    public String paramToWhereSql(JSONObject paramJson) {
        StringBuffer whereSql = new StringBuffer(this.getDeleteWhereSql());
        paramJson.keySet().forEach(condition -> this.paramToWhereSql(whereSql, paramJson, (String)condition));
        return whereSql.toString();
    }

    protected String paramToWhereSqlNotDeleteWhere(JSONObject paramJson) {
        StringBuffer whereSql = new StringBuffer(" WHERE 1 = 1 ");
        paramJson.keySet().forEach(condition -> this.paramToWhereSql(whereSql, paramJson, (String)condition));
        return whereSql.toString();
    }

    public String getDeleteWhereSql() {
        StringBuffer whereSql = new StringBuffer();
        if (this.getJdbcProperties().isEnableLogicDeleteFilter()) {
            whereSql.append(" WHERE ").append(this.getJdbcProperties().getFieldDefinitionDeleteTime()).append(" = ").append(DbConstant.FIELD_DEFAULT_VALUE_DELETE_TIME);
        } else {
            whereSql.append(" WHERE 1 = 1 ");
        }
        return whereSql.toString();
    }

    protected void paramValidate(String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, String whereSql) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)whereSql)) {
            throw new DbException("whereSql\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, Long id) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == id) {
            throw new DbException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, String ... columnNames) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])columnNames)) {
            throw new DbException("\u6761\u4ef6\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, Long id, String[] fieldName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == id) {
            throw new DbException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])fieldName)) {
            throw new DbException("fieldName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject paramJson) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmpty((Map)paramJson)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject[] paramJsons) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmptys((Map[])paramJsons)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject paramJson, String[] conditions) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmpty((Map)paramJson)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])conditions) || !MapUtils.isKeys((Map)paramJson, (String[])conditions, (String[])new String[0])) {
            throw new DbException("\u66f4\u65b0\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void paramFormat(JSONObject paramJson) {
        if (MapUtils.isEmpty((Map)paramJson)) {
            return;
        }
        JSONObject paramFormatJson = new JSONObject();
        for (Map.Entry entry : paramJson.entrySet()) {
            Object assertMap;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                paramFormatJson.put(key, value);
                continue;
            }
            String formatKey = key;
            if (this.getJdbcProperties().isEnableFieldNamingStrategyRecognition()) {
                formatKey = this.getJdbcProperties().getDatabaseFieldNamingStrategy().getPropertyNamingStrategy().translate(key);
            }
            Object formatValue = value;
            Class<?> valueClass = value.getClass();
            if (valueClass == JSONObject.class) {
                formatValue = ((JSONObject)value).toJSONString();
            } else if (valueClass == JSONArray.class) {
                formatValue = ((JSONArray)value).toJSONString();
            } else if (valueClass == Character.class || valueClass == LocalDateTime.class) {
                formatValue = value.toString();
            } else if (value instanceof List && ListUtils.isNotEmpty(Collections.singletonList(value)) && (assertMap = ((List)value).get(0)) instanceof Map) {
                formatValue = JSONObject.toJSONString(value);
            }
            boolean enableBooleanMapRecognition = this.getJdbcProperties().isEnableBooleanMapRecognition();
            boolean isBoolean = BooleanUtil.isBoolean(valueClass);
            boolean isStrBoolean = false;
            if (!isBoolean && valueClass == String.class) {
                isStrBoolean = StrUtil.equalsAnyIgnoreCase((CharSequence)((String)value), (CharSequence[])new CharSequence[]{"true", "false"});
            }
            if (enableBooleanMapRecognition && (isBoolean || isStrBoolean)) {
                if (!StrUtil.startWith((CharSequence)key, (CharSequence)IS_PREFIX, (boolean)true, (boolean)true)) {
                    String aliasFormat = String.format(IS_PREFIX_FORMAT, PropertyNamingStrategy.SnakeCase.translate(key));
                    formatKey = this.getJdbcProperties().getDatabaseFieldNamingStrategy().getPropertyNamingStrategy().translate(aliasFormat);
                }
                if (!BooleanUtil.isBoolean(valueClass)) {
                    formatValue = Boolean.parseBoolean((String)value);
                }
            }
            paramFormatJson.put(formatKey, formatValue);
        }
        paramJson.fluentClear().putAll((Map)paramFormatJson);
    }

    protected List<SchemaStatVisitor> extractSchemaStatVisitor(String sql) {
        DruidDataSource druidDataSource = this.getDruidDataSource();
        DbType dbType = DbType.of((String)druidDataSource.getDbType());
        List sqlStatements = SQLUtils.parseStatements((String)sql, (DbType)dbType);
        ArrayList<SchemaStatVisitor> schemaStatVisitorList = new ArrayList<SchemaStatVisitor>();
        for (SQLStatement sqlStatement : sqlStatements) {
            SchemaStatVisitor visitor = new SchemaStatVisitor();
            sqlStatement.accept((SQLASTVisitor)visitor);
            schemaStatVisitorList.add(visitor);
        }
        return schemaStatVisitorList;
    }

    protected String[] extractTables(String sql) {
        List<SchemaStatVisitor> schemaStatVisitorList = this.extractSchemaStatVisitor(sql);
        ArrayList tableNameList = new ArrayList();
        for (SchemaStatVisitor schemaStatVisitor : schemaStatVisitorList) {
            Set names = schemaStatVisitor.getTables().keySet();
            Iterator iterator = names.iterator();
            ArrayList<String> currentTableNameList = new ArrayList<String>();
            while (iterator.hasNext()) {
                currentTableNameList.add(((TableStat.Name)iterator.next()).getName());
            }
            tableNameList.addAll(currentTableNameList);
        }
        String[] tableNames = new String[tableNameList.size()];
        return tableNameList.toArray(tableNames);
    }

    private void dataEncrypt(Map<String, DataEncryptProperties> dataEncryptConfigs, String tableName, JSONObject ... paramJsons) {
        String unwrapTableName = this.dialect.getWrapper().unwrap(tableName);
        DataEncryptProperties dataEncryptProperties = dataEncryptConfigs.get(unwrapTableName);
        if (dataEncryptProperties == null) {
            return;
        }
        EncryptAlgorithmEnum dataEncryptAlgorithm = dataEncryptProperties.getDataEncryptAlgorithm();
        String dataEncryptKey = dataEncryptProperties.getDataEncryptKey();
        if (dataEncryptAlgorithm == null) {
            dataEncryptAlgorithm = this.getJdbcProperties().getDataEncryptAlgorithm();
        }
        if (dataEncryptKey == null) {
            dataEncryptKey = this.getJdbcProperties().getDataEncryptKey();
        }
        List<String> fieldNameList = dataEncryptProperties.getFieldNames();
        for (String fieldName : fieldNameList) {
            for (JSONObject paramJson : paramJsons) {
                String data = paramJson.getString(fieldName);
                if (data == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.warn("\u3010\u5b57\u6bb5\u52a0\u5bc6\u3011\u672a\u80fd\u83b7\u5f97\u52a0\u5bc6\u6570\u636e\uff0c\u5f53\u524d\u52a0\u5bc6\u8868\uff1a{}\uff0c\u52a0\u5bc6\u5b57\u6bb5\uff1a{}", (Object)unwrapTableName, (Object)fieldName);
                    continue;
                }
                String encryptedBase64 = dataEncryptAlgorithm.getSymmetricCrypto(dataEncryptKey).encryptBase64(data);
                paramJson.replace((Object)fieldName, (Object)encryptedBase64);
                log.debug("\u3010\u5b57\u6bb5\u52a0\u5bc6\u3011\u5f53\u524d\u52a0\u5bc6\u8868\uff1a{}\uff0c\u52a0\u5bc6\u5b57\u6bb5\uff1a{}\uff0c\u52a0\u5bc6\u524d\u6570\u636e\uff1a{}\uff0c\u52a0\u5bc6\u540e\u6570\u636e\uff1a{}", new Object[]{unwrapTableName, fieldName, data, encryptedBase64});
            }
        }
    }

    public void dataEncrypt(String tableName, JSONObject ... paramJsons) {
        Map<String, DataEncryptProperties> dataEncryptConfigs = this.getJdbcProperties().getDataEncryptConfigs();
        if (MapUtils.isEmpty(dataEncryptConfigs)) {
            return;
        }
        this.dataEncrypt(dataEncryptConfigs, tableName, paramJsons);
    }

    protected void dataEncryptExtractTable(String sql, JSONObject ... paramJsons) {
        String[] tableNames;
        Map<String, DataEncryptProperties> dataEncryptConfigs = this.getJdbcProperties().getDataEncryptConfigs();
        if (MapUtils.isEmpty(dataEncryptConfigs)) {
            return;
        }
        for (String tableName : tableNames = this.extractTables(sql)) {
            this.dataEncrypt(dataEncryptConfigs, tableName, paramJsons);
        }
    }

    private void dataDecrypt(Map<String, DataEncryptProperties> dataEncryptConfigs, String tableName, JSONObject[] resultJsons) {
        DataEncryptProperties dataEncryptProperties = dataEncryptConfigs.get(tableName);
        if (dataEncryptProperties == null) {
            return;
        }
        EncryptAlgorithmEnum dataEncryptAlgorithm = dataEncryptProperties.getDataEncryptAlgorithm();
        String dataEncryptKey = dataEncryptProperties.getDataEncryptKey();
        if (dataEncryptAlgorithm == null) {
            dataEncryptAlgorithm = this.getJdbcProperties().getDataEncryptAlgorithm();
        }
        if (dataEncryptKey == null) {
            dataEncryptKey = this.getJdbcProperties().getDataEncryptKey();
        }
        List<String> fieldNameList = dataEncryptProperties.getFieldNames();
        for (String fieldName : fieldNameList) {
            for (JSONObject resultJson : resultJsons) {
                String data = resultJson.getString(fieldName);
                if (data == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.warn("\u3010\u5b57\u6bb5\u89e3\u5bc6\u3011\u672a\u80fd\u83b7\u5f97\u89e3\u5bc6\u6570\u636e\uff0c\u5f53\u524d\u89e3\u5bc6\u8868\uff1a{}\uff0c\u89e3\u5bc6\u5b57\u6bb5\uff1a{}", (Object)tableName, (Object)fieldName);
                    continue;
                }
                String decryptStr = dataEncryptAlgorithm.getSymmetricCrypto(dataEncryptKey).decryptStr(data);
                resultJson.replace((Object)fieldName, (Object)decryptStr);
                log.debug("\u3010\u5b57\u6bb5\u89e3\u5bc6\u3011\u5f53\u524d\u89e3\u5bc6\u8868\uff1a{}\uff0c\u89e3\u5bc6\u5b57\u6bb5\uff1a{}\uff0c\u89e3\u5bc6\u524d\u6570\u636e\uff1a{}\uff0c\u89e3\u5bc6\u540e\u6570\u636e\uff1a{}", new Object[]{tableName, fieldName, data, decryptStr});
            }
        }
    }

    public void dataDecrypt(String tableName, JSONObject ... resultJsons) {
        Map<String, DataEncryptProperties> dataEncryptConfigs = this.getJdbcProperties().getDataEncryptConfigs();
        if (MapUtils.isEmpty(dataEncryptConfigs)) {
            return;
        }
        this.dataDecrypt(dataEncryptConfigs, tableName, resultJsons);
    }

    public void dataDecrypt(Class<?> mappedClass, JSONObject ... resultJsons) {
        Map<String, DataEncryptProperties> dataEncryptConfigs = this.getJdbcProperties().getDataEncryptConfigs();
        if (MapUtils.isEmpty(dataEncryptConfigs)) {
            return;
        }
        Table table = mappedClass.getAnnotation(Table.class);
        if (table == null) {
            return;
        }
        String tableName = table.value();
        if (StrUtil.isBlank((CharSequence)tableName)) {
            log.warn(StrUtil.format((CharSequence)"{}\u5b58\u5728\u7a7aTable\u6ce8\u89e3", (Object[])new Object[]{mappedClass}));
            return;
        }
        this.dataDecrypt(dataEncryptConfigs, tableName, resultJsons);
    }

    private void dataAudit(List<String> auditTableNames, String tableName, CrudEnum crudEnum, JSONObject ... paramJsons) {
        DataAuditProperties dataAuditProperties = this.getJdbcProperties().getDataAuditProperties();
        String fieldNameCreateUser = dataAuditProperties.getFieldNameCreateUser();
        String fieldNameCreateUserUuid = dataAuditProperties.getFieldNameCreateUserUuid();
        String fieldNameCreateTime = dataAuditProperties.getFieldNameCreateTime();
        String fieldNameUpdateUser = dataAuditProperties.getFieldNameUpdateUser();
        String fieldNameUpdateUserUuid = dataAuditProperties.getFieldNameUpdateUserUuid();
        String fieldNameUpdateTime = dataAuditProperties.getFieldNameUpdateTime();
        String fieldNameDeleteUser = dataAuditProperties.getFieldNameDeleteUser();
        String fieldNameDeleteUserUuid = dataAuditProperties.getFieldNameDeleteUserUuid();
        String fieldNameDeleteTime = dataAuditProperties.getFieldNameDeleteTime();
        String unwrapTableName = this.dialect.getWrapper().unwrap(tableName);
        for (String auditTableName : auditTableNames) {
            if (!unwrapTableName.equalsIgnoreCase(auditTableName)) continue;
            String user = null;
            String userUuid = null;
            try {
                user = ((AuditUserProvider)SpringUtils.getBean(AuditUserProvider.class)).getUser();
                userUuid = ((AuditUserProvider)SpringUtils.getBean(AuditUserProvider.class)).getUserUuid();
            }
            catch (Exception e) {
                log.error("\u3010\u6570\u636e\u5ba1\u8ba1\u3011\u672a\u627e\u5230\u5408\u9002\u7684Bean\uff1a{}", AuditUserProvider.class);
                throw e;
            }
            for (JSONObject paramJson : paramJsons) {
                if (crudEnum == CrudEnum.C) {
                    paramJson.put(fieldNameCreateUser, (Object)user);
                    paramJson.put(fieldNameCreateUserUuid, (Object)userUuid);
                    paramJson.put(fieldNameCreateTime, (Object)LocalDateTime.now());
                }
                if (crudEnum == CrudEnum.U) {
                    paramJson.put(fieldNameUpdateUser, (Object)user);
                    paramJson.put(fieldNameUpdateUserUuid, (Object)userUuid);
                    paramJson.put(fieldNameUpdateTime, (Object)LocalDateTime.now());
                }
                if (crudEnum != CrudEnum.D) continue;
                paramJson.put(fieldNameDeleteUser, (Object)user);
                paramJson.put(fieldNameDeleteUserUuid, (Object)userUuid);
                paramJson.put(fieldNameDeleteTime, (Object)System.currentTimeMillis());
            }
        }
    }

    protected void dataAudit(String tableName, CrudEnum crudEnum, JSONObject ... paramJsons) {
        List<String> dataAuditTableNames = this.getJdbcProperties().getDataAuditTableNames();
        ArrayList<String> cloneAuditTableNames = new ArrayList<String>();
        cloneAuditTableNames.addAll(dataAuditTableNames);
        MatchEnum dataAuditTableNameMatchEnum = this.getJdbcProperties().getDataAuditTableNameMatchEnum();
        if (dataAuditTableNameMatchEnum == MatchEnum.MATCH && ListUtils.isEmpty(cloneAuditTableNames)) {
            return;
        }
        if (dataAuditTableNameMatchEnum == MatchEnum.EXCLUDE) {
            String unwrapTableName = this.dialect.getWrapper().unwrap(tableName);
            for (String auditTableName : cloneAuditTableNames) {
                if (!unwrapTableName.equalsIgnoreCase(auditTableName)) continue;
                return;
            }
            cloneAuditTableNames.clear();
            cloneAuditTableNames.add(tableName);
        }
        this.dataAudit(cloneAuditTableNames, tableName, crudEnum, paramJsons);
    }

    protected void dataAuditExtractTable(String sql, CrudEnum crudEnum, JSONObject ... paramJsons) {
        List<String> dataAuditTableNames = this.getJdbcProperties().getDataAuditTableNames();
        ArrayList<String> cloneAuditTableNames = new ArrayList<String>();
        cloneAuditTableNames.addAll(dataAuditTableNames);
        MatchEnum dataAuditTableNameMatchEnum = this.getJdbcProperties().getDataAuditTableNameMatchEnum();
        String[] tableNames = new String[]{dataAuditTableNameMatchEnum.name()};
        if (dataAuditTableNameMatchEnum == MatchEnum.MATCH && ListUtils.isEmpty(cloneAuditTableNames)) {
            return;
        }
        if (dataAuditTableNameMatchEnum == MatchEnum.EXCLUDE) {
            String[] extractTables;
            String[] stringArray = extractTables = this.extractTables(sql);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String extractTable = stringArray[i];
                String unwrapTableName = this.dialect.getWrapper().unwrap(extractTable);
                for (String auditTableName : cloneAuditTableNames) {
                    if (!unwrapTableName.equalsIgnoreCase(auditTableName)) continue;
                    return;
                }
            }
            cloneAuditTableNames.clear();
            cloneAuditTableNames.add(dataAuditTableNameMatchEnum.name());
        } else {
            tableNames = this.extractTables(sql);
        }
        for (String tableName : tableNames) {
            this.dataAudit(cloneAuditTableNames, tableName, crudEnum, paramJsons);
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public String toString() {
        return "DbBase(dialect=" + this.getDialect() + ")";
    }
}

