/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client.dialect;

import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class Wrapper {
    private Character preWrapQuote;
    private Character sufWrapQuote;

    public Wrapper() {
    }

    public Wrapper(Character wrapQuote) {
        this.preWrapQuote = wrapQuote;
        this.sufWrapQuote = wrapQuote;
    }

    public Wrapper(Character preWrapQuote, Character sufWrapQuote) {
        this.preWrapQuote = preWrapQuote;
        this.sufWrapQuote = sufWrapQuote;
    }

    public char getPreWrapQuote() {
        return this.preWrapQuote.charValue();
    }

    public void setPreWrapQuote(Character preWrapQuote) {
        this.preWrapQuote = preWrapQuote;
    }

    public char getSufWrapQuote() {
        return this.sufWrapQuote.charValue();
    }

    public void setSufWrapQuote(Character sufWrapQuote) {
        this.sufWrapQuote = sufWrapQuote;
    }

    public String wrap(String field) {
        if (this.preWrapQuote == null || this.sufWrapQuote == null || StrUtil.isBlank((CharSequence)field)) {
            return field;
        }
        if (StrUtil.isSurround((CharSequence)field, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue())) {
            return field;
        }
        if (StrUtil.containsAnyIgnoreCase((CharSequence)field, (CharSequence[])new CharSequence[]{"*", "(", " ", " as "})) {
            return field;
        }
        if (field.contains(".")) {
            Collection target = CollUtil.edit((Collection)StrUtil.split((CharSequence)field, (char)'.', (int)2), t -> StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, t, this.sufWrapQuote}));
            return CollectionUtil.join((Iterable)target, (CharSequence)".");
        }
        return StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, field, this.sufWrapQuote});
    }

    public String[] wrap(String ... fields) {
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return fields;
        }
        String[] wrappedFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            wrappedFields[i] = this.wrap(fields[i]);
        }
        return wrappedFields;
    }

    public Collection<String> wrap(Collection<String> fields) {
        if (CollectionUtil.isEmpty(fields)) {
            return fields;
        }
        return Arrays.asList(this.wrap(fields.toArray(new String[0])));
    }

    public JSONObject wrap(JSONObject paramJson) {
        if (MapUtils.isEmpty((Map)paramJson)) {
            return paramJson;
        }
        JSONObject paramJsonWrapped = new JSONObject();
        paramJson.forEach((key, value) -> paramJsonWrapped.put(this.wrap((String)key), value));
        return paramJsonWrapped;
    }

    public JSONObject[] wrap(JSONObject[] paramJsons) {
        if (MapUtils.isEmptys((Map[])paramJsons)) {
            return paramJsons;
        }
        JSONObject[] paramJsonWraps = new JSONObject[paramJsons.length];
        for (int i = 0; i < paramJsons.length; ++i) {
            paramJsonWraps[i] = this.wrap(paramJsons[i]);
        }
        return paramJsonWraps;
    }

    public String unwrap(String field) {
        if (StringUtils.isEmpty((CharSequence)field)) {
            return field;
        }
        return StringUtils.deleteFirstLastEqualString((String)field, (String)CharUtil.toString((char)this.getPreWrapQuote()), (String)CharUtil.toString((char)this.getSufWrapQuote()));
    }
}

