/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.constant;

import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.data.jdbc.crypto.AesSymmetricCrypto;
import ai.yue.library.data.jdbc.crypto.Sm4SymmetricCrypto;
import ai.yue.library.data.jdbc.crypto.SymmetricCrypto;

public enum EncryptAlgorithmEnum {
    AES{

        @Override
        public SymmetricCrypto getSymmetricCrypto(String dataEncryptKey) {
            AesSymmetricCrypto symmetricCrypto = new AesSymmetricCrypto();
            symmetricCrypto.initEncryptAlgorithm(dataEncryptKey);
            return symmetricCrypto;
        }
    }
    ,
    SM4{

        @Override
        public SymmetricCrypto getSymmetricCrypto(String dataEncryptKey) {
            Sm4SymmetricCrypto symmetricCrypto = new Sm4SymmetricCrypto();
            symmetricCrypto.initEncryptAlgorithm(dataEncryptKey);
            return symmetricCrypto;
        }
    }
    ,
    CUSTOM{

        @Override
        public SymmetricCrypto getSymmetricCrypto(String dataEncryptKey) {
            SymmetricCrypto symmetricCrypto = (SymmetricCrypto)SpringUtils.getBean(SymmetricCrypto.class);
            symmetricCrypto.initEncryptAlgorithm(dataEncryptKey);
            return symmetricCrypto;
        }
    };


    public abstract SymmetricCrypto getSymmetricCrypto(String var1);
}

