/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.dao;

import ai.yue.library.data.jdbc.client.Db;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageVO;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AbstractBaseDAO<T> {
    @Autowired
    protected Db db;
    protected String tableName = this.tableName();

    AbstractBaseDAO() {
    }

    protected abstract String tableName();

    public Long insert(JSONObject paramJson) {
        return this.db.insert(this.tableName(), paramJson);
    }

    public String insertAndReturnUuid(JSONObject paramJson) {
        return this.db.insertAndReturnUuid(this.tableName(), paramJson);
    }

    public void insertBatch(JSONObject[] paramJsons) {
        this.db.insertBatch(this.tableName(), paramJsons);
    }

    public void deleteById(Long id) {
        this.db.deleteById(this.tableName(), id);
    }

    public void deleteByUuid(String uuidValue) {
        this.db.deleteByUuid(this.tableName, uuidValue);
    }

    public void deleteLogicById(Long id) {
        this.db.deleteLogicById(this.tableName(), id);
    }

    public void deleteLogicByUuid(String uuidValue) {
        this.db.deleteLogicByUuid(this.tableName, uuidValue);
    }

    public void updateById(JSONObject paramJson) {
        this.db.updateById(this.tableName(), paramJson);
    }

    public void updateByUuid(JSONObject paramJson) {
        this.db.updateByUuid(this.tableName(), paramJson);
    }

    public abstract T getById(Long var1);

    public abstract T getByUuid(String var1);

    public abstract List<T> listAll();

    public abstract PageVO<T> page(PageIPO var1);

    public abstract PageVO<T> pageDESC(PageIPO var1);
}

