/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.provider;

import ai.yue.library.base.constant.MatchEnum;
import ai.yue.library.base.util.IdUtils;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.data.jdbc.config.properties.JdbcProperties;
import ai.yue.library.data.jdbc.dto.DataFillDTO;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FillDataProvider {
    private static final Logger log = LoggerFactory.getLogger(FillDataProvider.class);

    private static FillDataProvider getFillDataProvider(JdbcProperties jdbcProperties, String tableName) {
        FillDataProvider fillDataProvider = null;
        try {
            fillDataProvider = (FillDataProvider)SpringUtils.getBean(FillDataProvider.class);
        }
        catch (Exception e) {
            log.debug("\u3010\u6570\u636e\u586b\u5145\u3011\u672a\u914d\u7f6e{}\uff0c\u6570\u636e\u586b\u5145\u7279\u6027\u672a\u751f\u6548\u3002", FillDataProvider.class);
            return fillDataProvider;
        }
        MatchEnum dataFillTableNameMatchEnum = jdbcProperties.getDataFillTableNameMatchEnum();
        List<String> dataFillTableNames = jdbcProperties.getDataFillTableNames();
        boolean matchResult = dataFillTableNameMatchEnum.getExecResult(tableName, dataFillTableNames);
        if (matchResult) {
            return fillDataProvider;
        }
        return null;
    }

    public static JSONObject getInsertParamJson(JdbcProperties jdbcProperties, String tableName) {
        JSONObject paramJson = new JSONObject();
        FillDataProvider fillDataProvider = FillDataProvider.getFillDataProvider(jdbcProperties, tableName);
        if (fillDataProvider == null) {
            return paramJson;
        }
        List<DataFillDTO> insertFillDTOList = fillDataProvider.getInsertFillDTO(jdbcProperties);
        insertFillDTOList.forEach(insertFillDTO -> paramJson.put(insertFillDTO.getFillFieldName(), insertFillDTO.getFillFieldValue()));
        return paramJson;
    }

    public static JSONObject getUpdateParamJson(JdbcProperties jdbcProperties, String tableName) {
        JSONObject paramJson = new JSONObject();
        FillDataProvider fillDataProvider = FillDataProvider.getFillDataProvider(jdbcProperties, tableName);
        if (fillDataProvider == null) {
            return paramJson;
        }
        List<DataFillDTO> updateFillDTOList = fillDataProvider.getUpdateFillDTO(jdbcProperties);
        updateFillDTOList.forEach(updateFillDTO -> paramJson.put(updateFillDTO.getFillFieldName(), updateFillDTO.getFillFieldValue()));
        return paramJson;
    }

    public List<DataFillDTO> getInsertFillDTO(JdbcProperties jdbcProperties) {
        ArrayList<DataFillDTO> insertFillDTOList = new ArrayList<DataFillDTO>();
        insertFillDTOList.add(new DataFillDTO(jdbcProperties.getFieldDefinitionUuid(), IdUtils.getSimpleUUID()));
        insertFillDTOList.add(new DataFillDTO(jdbcProperties.getFieldDefinitionSortIdx(), 0));
        return insertFillDTOList;
    }

    public List<DataFillDTO> getUpdateFillDTO(JdbcProperties jdbcProperties) {
        ArrayList<DataFillDTO> updateFillDTOList = new ArrayList<DataFillDTO>();
        return updateFillDTOList;
    }
}

