/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.support;

import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.data.jdbc.client.DbBase;
import ai.yue.library.data.jdbc.support.ColumnMapRowMapper;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;

public class BeanPropertyRowMapper<T>
implements RowMapper<T> {
    private Class<T> mappedClass;
    private DbBase dbBase;

    public BeanPropertyRowMapper(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
    }

    public BeanPropertyRowMapper(Class<T> mappedClass, DbBase dbBase) {
        this.mappedClass = mappedClass;
        this.dbBase = dbBase;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ColumnMapRowMapper columnMapRowMapper = new ColumnMapRowMapper();
        JSONObject resultJson = columnMapRowMapper.mapRow(rs, rowNum);
        if (this.dbBase != null) {
            this.dbBase.dataDecrypt(this.mappedClass, resultJson);
        }
        return (T)(MapUtils.isEmpty((Map)resultJson) ? null : Convert.toJavaBean((Object)resultJson, this.mappedClass));
    }
}

