/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.base.view.ResultPrompt;
import ai.yue.library.data.jdbc.client.dialect.Dialect;
import ai.yue.library.data.jdbc.config.properties.JdbcProperties;
import ai.yue.library.data.jdbc.constant.DbConstant;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class DbBase {
    private static final Logger log = LoggerFactory.getLogger(DbBase.class);
    protected Dialect dialect;
    private static final String IS_PREFIX = "is";
    private static final String IS_PREFIX_FORMAT = "is_%s";

    public DataSource getDataSource() {
        return this.getJdbcTemplate().getDataSource();
    }

    public void setDataSource(DataSource dataSource) {
        this.getJdbcTemplate().setDataSource(dataSource);
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.dialect.getNamedParameterJdbcTemplate();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.getNamedParameterJdbcTemplate().getJdbcTemplate();
    }

    public JdbcProperties getJdbcProperties() {
        return this.dialect.getJdbcProperties();
    }

    public boolean isDataSize(long dataSize) {
        return dataSize > 0L;
    }

    public boolean isUpdateAndExpectedEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber == (long)expectedValue) {
            return true;
        }
        if (updateRowsNumber == 0L) {
            return false;
        }
        String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
        throw new DbException(msg);
    }

    public boolean isUpdateAndExpectedGreaterThanEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber >= (long)expectedValue) {
            return true;
        }
        if (updateRowsNumber == 0L) {
            return false;
        }
        String msg = ResultPrompt.dataStructure((Object)(">= " + expectedValue), (Object)updateRowsNumber);
        throw new DbException(msg);
    }

    public void updateAndExpectedEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber != (long)expectedValue) {
            String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
            throw new DbException(msg);
        }
    }

    public void updateAndExpectedGreaterThanEqual(long updateRowsNumber, int expectedValue) {
        if (updateRowsNumber < (long)expectedValue) {
            String msg = ResultPrompt.dataStructure((Object)(">= " + expectedValue), (Object)updateRowsNumber);
            throw new DbException(msg);
        }
    }

    public void updateBatchAndExpectedEqual(int[] updateRowsNumberArray, int expectedValue) {
        for (int updateRowsNumber : updateRowsNumberArray) {
            if (updateRowsNumber == expectedValue) continue;
            String msg = "\u6267\u884c\u6279\u6b21\u66f4\u65b0\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002";
            msg = msg + ResultPrompt.dataStructure((Object)expectedValue, (Object)updateRowsNumber);
            throw new DbException(msg);
        }
    }

    public JSONObject resultToJson(List<JSONObject> list) {
        int expectedValue;
        int size = list.size();
        if (size != (expectedValue = 1)) {
            if (size > expectedValue) {
                String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)size);
                log.warn(msg);
            }
            return null;
        }
        return list.get(0);
    }

    public <T> T resultToObject(List<T> list) {
        int expectedValue;
        int size = list.size();
        if (size != (expectedValue = 1)) {
            if (size > expectedValue) {
                String msg = ResultPrompt.dataStructure((Object)expectedValue, (Object)size);
                log.warn(msg);
            }
            return null;
        }
        return list.get(0);
    }

    private synchronized void paramToWhereSql(StringBuffer whereSql, JSONObject paramJson, String condition) {
        whereSql.append(" AND ");
        whereSql.append(this.dialect.getWrapper().wrap(condition));
        Object value = paramJson.get((Object)condition);
        if (null == value) {
            whereSql.append(" IS :");
            whereSql.append(condition);
        } else if (value instanceof Collection || ArrayUtil.isArray((Object)value)) {
            whereSql.append(" IN (:");
            whereSql.append(condition);
            whereSql.append(") ");
            if (ArrayUtil.isArray((Object)value)) {
                paramJson.replace((Object)condition, (Object)ListUtils.toList((Object[])((Object[])value)));
            }
        } else {
            whereSql.append(" = :");
            whereSql.append(condition);
        }
    }

    protected String paramToWhereSql(JSONObject paramJson, String ... conditions) {
        StringBuffer whereSql = new StringBuffer();
        whereSql.append(" WHERE 1 = 1 ");
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            for (String condition : conditions) {
                this.paramToWhereSql(whereSql, paramJson, condition);
            }
        }
        return whereSql.toString();
    }

    public String paramToWhereSql(JSONObject paramJson) {
        StringBuffer whereSql = new StringBuffer();
        if (this.getJdbcProperties().isEnableDeleteQueryFilter()) {
            whereSql.append(" WHERE ").append("delete_time").append(" = ").append(DbConstant.FIELD_DEFAULT_VALUE_DELETE_TIME);
        } else {
            whereSql.append(" WHERE 1 = 1 ");
        }
        paramJson.keySet().forEach(condition -> this.paramToWhereSql(whereSql, paramJson, (String)condition));
        return whereSql.toString();
    }

    protected void paramValidate(String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, String whereSql) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)whereSql)) {
            throw new DbException("whereSql\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, Long id) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == id) {
            throw new DbException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, String ... columnNames) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])columnNames)) {
            throw new DbException("\u6761\u4ef6\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, Long id, String[] fieldName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == id) {
            throw new DbException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])fieldName)) {
            throw new DbException("fieldName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject paramJson) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmpty((Map)paramJson)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject[] paramJsons) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmptys((Map[])paramJsons)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void paramValidate(String tableName, JSONObject paramJson, String[] conditions) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new DbException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmpty((Map)paramJson)) {
            throw new DbException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmptys((String[])conditions) || !MapUtils.isKeys((Map)paramJson, (String[])conditions, (String[])new String[0])) {
            throw new DbException("\u66f4\u65b0\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void paramFormat(JSONObject paramJson) {
        if (MapUtils.isEmpty((Map)paramJson)) {
            return;
        }
        JSONObject paramFormatJson = new JSONObject();
        for (Map.Entry entry : paramJson.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                paramFormatJson.put(key, value);
                continue;
            }
            String formatKey = key;
            Object formatValue = value;
            Class<?> valueClass = value.getClass();
            if (valueClass == JSONObject.class) {
                formatValue = ((JSONObject)value).toJSONString();
            }
            boolean enableBooleanMapRecognition = this.getJdbcProperties().isEnableBooleanMapRecognition();
            boolean isBoolean = BooleanUtil.isBoolean(valueClass);
            boolean isStrBoolean = false;
            if (!isBoolean && valueClass == String.class) {
                isStrBoolean = StrUtil.equalsAnyIgnoreCase((CharSequence)((String)value), (CharSequence[])new CharSequence[]{"true", "false"});
            }
            if ((enableBooleanMapRecognition && isBoolean || isStrBoolean) && !StrUtil.startWith((CharSequence)key, (CharSequence)IS_PREFIX, (boolean)true, (boolean)true)) {
                String aliasFormat = String.format(IS_PREFIX_FORMAT, PropertyNamingStrategy.SnakeCase.translate(key));
                formatKey = this.getJdbcProperties().getDatabaseFieldNamingStrategy().getPropertyNamingStrategy().translate(aliasFormat);
                if (!BooleanUtil.isBoolean(valueClass)) {
                    formatValue = Boolean.parseBoolean((String)value);
                }
            }
            paramFormatJson.put(formatKey, formatValue);
        }
        paramJson.fluentClear().putAll((Map)paramFormatJson);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public String toString() {
        return "DbBase(dialect=" + this.getDialect() + ")";
    }
}

