/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.data.jdbc.client.DbUpdate;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

class DbDelete
extends DbUpdate {
    DbDelete() {
    }

    private String deleteSqlBuild(String tableName, JSONObject paramJson) {
        this.paramValidate(tableName, paramJson);
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        sql.append(this.paramToWhereSql(paramJson));
        return sql.toString();
    }

    private void deleteByUk(String tableName, Object uk) {
        this.paramValidate(tableName);
        if (ObjectUtils.isNull((Object)uk)) {
            throw new DbException("\u5220\u9664\u6761\u4ef6\u4e0d\u80fd\u4e3anull");
        }
        JSONObject data = null;
        String key = null;
        if (uk instanceof Long) {
            data = this.getById(tableName, (Long)uk);
            key = "id";
        } else if (uk instanceof String) {
            data = this.getByBusinessUk(tableName, (String)uk);
            key = this.getJdbcProperties().getBusinessUk();
        }
        if (data == null || data.isEmpty()) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u5f02\u5e38\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5b58\u5728\u591a\u6761\u6570\u636e", true);
        }
        JSONObject paramJson = new JSONObject();
        paramJson.put(key, uk);
        String sql = this.deleteSqlBuild(tableName, paramJson);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        if (updateRowsNumber != 1) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void delete(String tableName, Long id) {
        this.deleteByUk(tableName, id);
    }

    @Deprecated
    public void deleteSafe(String tableName, Long id) {
        JSONObject data = this.getById(tableName, id);
        if (data == null || data.isEmpty()) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u5f02\u5e38\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5b58\u5728\u591a\u6761\u6570\u636e", true);
        }
        this.delete(tableName, id);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public void deleteByBusinessUk(String tableName, String businessUkValue) {
        this.deleteByUk(tableName, businessUkValue);
    }

    @Transactional(rollbackFor={RuntimeException.class, Error.class})
    public long delete(String tableName, JSONObject paramJson) {
        this.paramFormat(paramJson);
        String sql = this.deleteSqlBuild(tableName, paramJson);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional
    public void deleteBatch(String tableName, JSONObject[] paramJsons) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.deleteBatchNotParamFormat(tableName, paramJsons);
    }

    @Transactional
    public void deleteBatchNotParamFormat(String tableName, JSONObject[] paramJsons) {
        int[] updateRowsNumberArray;
        String sql = this.deleteSqlBuild(tableName, paramJsons[0]);
        for (int updateRowsNumber : updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons)) {
            if (updateRowsNumber <= 1) continue;
            throw new DbException("\u6267\u884c\u6279\u6b21\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional
    public int[] deleteBatch2(String sql, JSONObject[] paramJsons) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        return this.deleteBatchNotParamFormat2(sql, paramJsons);
    }

    @Transactional
    public int[] deleteBatchNotParamFormat2(String sql, JSONObject[] paramJsons) {
        return this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
    }

    private String deleteLogicSqlBuild(String tableName, JSONObject paramJson) {
        this.paramValidate(tableName, paramJson);
        String[] conditions = new String[paramJson.size()];
        conditions = MapUtils.keyList((Map)paramJson).toArray(conditions);
        paramJson.put("delete_time", (Object)System.currentTimeMillis());
        return this.dialect.updateSqlBuild(tableName, paramJson, conditions, DbUpdateEnum.NORMAL);
    }

    private void deleteLogicByUk(String tableName, Object uk) {
        this.paramValidate(tableName);
        if (ObjectUtils.isNull((Object)uk)) {
            throw new DbException("\u5220\u9664\u6761\u4ef6\u4e0d\u80fd\u4e3anull");
        }
        String key = null;
        if (uk instanceof Long) {
            key = "id";
        } else if (uk instanceof String) {
            key = this.getJdbcProperties().getBusinessUk();
        }
        JSONObject paramJson = new JSONObject();
        paramJson.put(key, uk);
        String sql = this.deleteLogicSqlBuild(tableName, paramJson);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        if (updateRowsNumber != 1) {
            throw new DbException("\u6267\u884c\u5355\u884c\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional
    public void deleteLogic(String tableName, Long id) {
        this.deleteLogicByUk(tableName, id);
    }

    @Transactional
    public void deleteLogicByBusinessUk(String tableName, String businessUkValue) {
        this.deleteLogicByUk(tableName, businessUkValue);
    }

    @Transactional
    public long deleteLogic(String tableName, JSONObject paramJson) {
        this.paramFormat(paramJson);
        String sql = this.deleteLogicSqlBuild(tableName, paramJson);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional
    public void deleteBatchLogic(String tableName, JSONObject[] paramJsons) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.deleteBatchLogicNotParamFormat(tableName, paramJsons);
    }

    @Transactional
    public void deleteBatchLogicNotParamFormat(String tableName, JSONObject[] paramJsons) {
        int[] updateRowsNumberArray;
        String sql = this.deleteLogicSqlBuild(tableName, paramJsons[0]);
        for (int updateRowsNumber : updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons)) {
            if (updateRowsNumber <= 1) continue;
            throw new DbException("\u6267\u884c\u6279\u6b21\u5220\u9664\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }
}

