/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.dao;

import ai.yue.library.base.constant.SortEnum;
import ai.yue.library.data.jdbc.client.Db;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageVO;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDAO {
    @Autowired
    protected Db db;
    protected String tableName = this.tableName();

    protected abstract String tableName();

    public Long insert(JSONObject paramJson) {
        return this.db.insert(this.tableName(), paramJson);
    }

    public void insertBatch(JSONObject[] paramJsons) {
        this.db.insertBatch(this.tableName(), paramJsons);
    }

    public void delete(Long id) {
        this.db.delete(this.tableName(), id);
    }

    @Deprecated
    public void deleteSafe(Long id) {
        this.db.deleteSafe(this.tableName(), id);
    }

    public void deleteByBusinessUk(String businessUkValue) {
        this.db.deleteByBusinessUk(this.tableName, businessUkValue);
    }

    public void deleteLogicByBusinessUk(String businessUkValue) {
        this.db.deleteLogicByBusinessUk(this.tableName, businessUkValue);
    }

    public void updateById(JSONObject paramJson) {
        this.db.updateById(this.tableName(), paramJson);
    }

    public void updateByBusinessUk(JSONObject paramJson) {
        this.db.updateByBusinessUk(this.tableName(), paramJson);
    }

    public JSONObject get(Long id) {
        return this.db.getById(this.tableName(), id);
    }

    public JSONObject getByBusinessUk(String businessUkValue) {
        return this.db.getByBusinessUk(this.tableName(), businessUkValue);
    }

    public List<JSONObject> listAll() {
        return this.db.listAll(this.tableName());
    }

    public PageVO page(PageIPO pageIPO) {
        return this.db.page(this.tableName(), pageIPO);
    }

    public PageVO pageDESC(PageIPO pageIPO) {
        return this.db.page(this.tableName(), pageIPO, SortEnum.DESC);
    }
}

