/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.support;

import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.util.MapUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;

public class BeanPropertyRowMapper<T>
implements RowMapper<T> {
    @Nullable
    private Class<T> mappedClass;

    public BeanPropertyRowMapper(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ColumnMapRowMapper columnMapRowMapper = new ColumnMapRowMapper();
        Map resultJson = columnMapRowMapper.mapRow(rs, rowNum);
        return (T)(MapUtils.isEmpty((Map)resultJson) ? null : Convert.toJavaBean((Object)resultJson, this.mappedClass));
    }

    public static <T> BeanPropertyRowMapper<T> newInstance(Class<T> mappedClass) {
        return new BeanPropertyRowMapper<T>(mappedClass);
    }
}

