/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.data.jdbc.client.DbDelete;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.transaction.annotation.Transactional;

class DbInsert
extends DbDelete {
    DbInsert() {
    }

    private SimpleJdbcInsert insertInit(String tableName, JSONObject paramJson) {
        this.paramValidate(tableName, paramJson);
        SimpleJdbcInsert simpleJdbcInsert = new SimpleJdbcInsert(this.getJdbcTemplate());
        simpleJdbcInsert.setTableName(tableName);
        simpleJdbcInsert.setGeneratedKeyName("id");
        List keys = MapUtils.keyList((Map)paramJson);
        ArrayList columnNames = ListUtils.toList((Object[])this.getMetaData(tableName).getColumnNames());
        List insertColumn = ListUtils.keepSameValue((List)keys, (List)((List)this.dialect.getWrapper().wrap(columnNames)));
        simpleJdbcInsert.setColumnNames(insertColumn);
        return simpleJdbcInsert;
    }

    @Transactional
    public Long insert(String tableName, JSONObject paramJson) {
        MapUtils.removeEmpty((Map)paramJson);
        this.paramFormat(paramJson);
        tableName = this.dialect.getWrapper().wrap(tableName);
        paramJson = this.dialect.getWrapper().wrap(paramJson);
        SimpleJdbcInsert simpleJdbcInsert = this.insertInit(tableName, paramJson);
        return simpleJdbcInsert.executeAndReturnKey((Map)paramJson).longValue();
    }

    @Transactional
    public void insertNotReturn(String tableName, JSONObject paramJson) {
        MapUtils.removeEmpty((Map)paramJson);
        this.paramFormat(paramJson);
        tableName = this.dialect.getWrapper().wrap(tableName);
        paramJson = this.dialect.getWrapper().wrap(paramJson);
        SimpleJdbcInsert simpleJdbcInsert = this.insertInit(tableName, paramJson);
        simpleJdbcInsert.execute((Map)paramJson);
    }

    @Transactional
    public Long insertWithSortIdxAutoIncrement(String tableName, JSONObject paramJson, String ... uniqueKeys) {
        long l;
        this.paramValidate(tableName, paramJson);
        tableName = this.dialect.getWrapper().wrap(tableName);
        String fieldDefinitionSortIdxWrapped = this.dialect.getWrapper().wrap("sort_idx");
        this.paramFormat(paramJson);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + fieldDefinitionSortIdxWrapped + " FROM ");
        sql.append(tableName);
        sql.append(this.paramToWhereSql(paramJson, uniqueKeys));
        sql.append(" ORDER BY " + fieldDefinitionSortIdxWrapped + " DESC LIMIT 1");
        paramJson = this.dialect.getWrapper().wrap(paramJson);
        Long sort_idx = this.queryForObject(sql.toString(), paramJson, Long.class);
        if (sort_idx == null) {
            l = 1L;
        } else {
            Long l2 = sort_idx;
            Long l3 = sort_idx = Long.valueOf(sort_idx + 1L);
            l = l2;
        }
        sort_idx = l;
        paramJson.put(fieldDefinitionSortIdxWrapped, (Object)sort_idx);
        return this.insert(tableName, paramJson);
    }

    public void insertBatch(String tableName, JSONObject[] paramJsons) {
        this.paramValidate(tableName, paramJsons);
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.insertBatchNotParamFormat(tableName, paramJsons);
    }

    @Transactional
    public void insertBatchNotParamFormat(String tableName, JSONObject[] paramJsons) {
        this.paramValidate(tableName, paramJsons);
        tableName = this.dialect.getWrapper().wrap(tableName);
        paramJsons = this.dialect.getWrapper().wrap(paramJsons);
        SimpleJdbcInsert simpleJdbcInsert = this.insertInit(tableName, paramJsons[0]);
        int updateRowsNumber = simpleJdbcInsert.executeBatch((Map[])paramJsons).length;
        if (updateRowsNumber != paramJsons.length) {
            throw new DbException("\u6267\u884c\u591a\u884c\u63d2\u5165\u547d\u4ee4\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u6570\u636e\u7ed3\u6784\u5f02\u5e38\u6216\u65e0ID\u4e3b\u952e\u3002\u8bf7\u7acb\u5373\u68c0\u67e5\u6570\u636e\u7684\u4e00\u81f4\u6027\u3001\u552f\u4e00\u6027\u3002");
        }
    }

    @Transactional
    public Long insertOrUpdate(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        return this.dialect.insertOrUpdate(tableName, paramJson, conditions, dBUpdateEnum);
    }
}

