/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client;

import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.DbQuery;
import ai.yue.library.data.jdbc.constant.DbExpectedEnum;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.transaction.annotation.Transactional;

class DbUpdate
extends DbQuery {
    DbUpdate() {
    }

    @Transactional
    public KeyHolder update(String sql, SqlParameterSource paramSource, KeyHolder generatedKeyHolder) {
        this.getNamedParameterJdbcTemplate().update(sql, paramSource, generatedKeyHolder);
        return generatedKeyHolder;
    }

    @Transactional
    public Long update(String sql, SqlParameterSource paramSource) {
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        long updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql.toString(), paramSource, (KeyHolder)generatedKeyHolder);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        return generatedKeyHolder.getKey().longValue();
    }

    @Transactional
    public long update(String sql, JSONObject paramJson) {
        this.paramFormat(paramJson);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional
    public void update(String sql, JSONObject paramJson, int expectedValue, DbExpectedEnum dBExpectedEnum) {
        this.paramFormat(paramJson);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        if (DbExpectedEnum.EQ == dBExpectedEnum) {
            this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        } else if (DbExpectedEnum.GE == dBExpectedEnum) {
            this.updateAndExpectedGreaterThanEqual(updateRowsNumber, expectedValue);
        }
    }

    @Transactional
    public int[] updateBatch(String sql, JSONObject[] paramJsons) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        return this.updateBatchNotParamFormat(sql, paramJsons);
    }

    @Transactional
    public int[] updateBatchNotParamFormat(String sql, JSONObject[] paramJsons) {
        return this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
    }

    protected String updateSqlBuild(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        this.paramValidate(tableName, paramJson, conditions);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(this.dialect.getWrapper().wrap(tableName));
        sql.append(" SET ");
        Set keys = paramJson.keySet();
        for (String key : keys) {
            if (ArrayUtil.contains((Object[])conditions, (Object)key)) continue;
            sql.append(this.dialect.getWrapper().wrap(key));
            sql.append(" = ");
            if (dBUpdateEnum == DbUpdateEnum.INCREMENT) {
                sql.append(this.dialect.getWrapper().wrap(key));
                sql.append(" + :");
            } else if (dBUpdateEnum == DbUpdateEnum.DECR || dBUpdateEnum == DbUpdateEnum.DECR_UNSIGNED) {
                sql.append(this.dialect.getWrapper().wrap(key));
                sql.append(" - :");
            } else {
                sql.append(":");
            }
            sql.append(key);
            sql.append(", ");
        }
        sql = new StringBuffer(StringUtils.deleteLastEqualString((CharSequence)sql, (CharSequence)", "));
        String whereSql = this.paramToWhereSql(paramJson, conditions);
        sql.append(whereSql);
        if (dBUpdateEnum == DbUpdateEnum.DECR_UNSIGNED) {
            List updateKeys = MapUtils.keyList((Map)paramJson);
            for (String key : updateKeys) {
                if (ArrayUtil.contains((Object[])conditions, (Object)key)) continue;
                sql.append(" AND ");
                sql.append(this.dialect.getWrapper().wrap(key));
                sql.append(" >= :");
                sql.append(key);
            }
        }
        return sql.toString();
    }

    @Transactional
    public Long update(String tableName, JSONObject paramJson, String[] conditions) {
        this.paramFormat(paramJson);
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, DbUpdateEnum.NORMAL);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional
    public Long update(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        this.paramFormat(paramJson);
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
        return this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
    }

    @Transactional
    public void update(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum, int expectedValue, DbExpectedEnum dBExpectedEnum) {
        this.paramFormat(paramJson);
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        if (DbExpectedEnum.EQ == dBExpectedEnum) {
            this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
        } else if (DbExpectedEnum.GE == dBExpectedEnum) {
            this.updateAndExpectedGreaterThanEqual(updateRowsNumber, expectedValue);
        }
    }

    @Transactional
    public void updateById(String tableName, JSONObject paramJson) {
        this.updateById(tableName, paramJson, DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void updateById(String tableName, JSONObject paramJson, DbUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{"id"};
        this.paramFormat(paramJson);
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
    }

    @Transactional
    public void updateById(String tableName, JSONObject[] paramJsons, DbUpdateEnum dBUpdateEnum) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.updateByIdNotParamFormat(tableName, paramJsons, dBUpdateEnum);
    }

    @Transactional
    public void updateByIdNotParamFormat(String tableName, JSONObject[] paramJsons, DbUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{"id"};
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dBUpdateEnum);
        int[] updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }

    @Transactional
    public void updateByBusinessUk(String tableName, JSONObject paramJson) {
        this.updateByBusinessUk(tableName, paramJson, DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void updateByBusinessUk(String tableName, JSONObject paramJson, DbUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{this.getJdbcProperties().getBusinessUk()};
        this.paramFormat(paramJson);
        String sql = this.updateSqlBuild(tableName, paramJson, conditions, dBUpdateEnum);
        int updateRowsNumber = this.getNamedParameterJdbcTemplate().update(sql, (Map)paramJson);
        int expectedValue = 1;
        this.updateAndExpectedEqual(updateRowsNumber, expectedValue);
    }

    @Transactional
    public void updateByBusinessUk(String tableName, JSONObject[] paramJsons, DbUpdateEnum dBUpdateEnum) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.updateByBusinessUkNotParamFormat(tableName, paramJsons, dBUpdateEnum);
    }

    @Transactional
    public void updateByBusinessUkNotParamFormat(String tableName, JSONObject[] paramJsons, DbUpdateEnum dBUpdateEnum) {
        String[] conditions = new String[]{this.getJdbcProperties().getBusinessUk()};
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dBUpdateEnum);
        int[] updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }

    @Transactional
    public void updateSort(String tableName, Long id, Integer move, String ... uniqueKeys) {
        long i;
        this.paramValidate(tableName);
        if (move == 0) {
            throw new DbException("move <= 0");
        }
        JSONObject sortJson = this.getById(tableName, id);
        long sortIdx = sortJson.getLongValue("sort_idx");
        long updateSortIdx = sortIdx + (long)move.intValue();
        if (updateSortIdx < 1L) {
            throw new DbException("\u6392\u5e8f\u540e\u7684\u7d22\u5f15\u503c\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        ArrayList<Long> updateSortList = new ArrayList<Long>();
        boolean isASC = false;
        if (updateSortIdx > sortIdx) {
            isASC = true;
            for (i = updateSortIdx; i > sortIdx; --i) {
                updateSortList.add(i);
            }
        } else {
            for (i = updateSortIdx; i < sortIdx; ++i) {
                updateSortList.add(i);
            }
        }
        JSONObject paramJson = new JSONObject();
        if (ArrayUtil.isNotEmpty((Object[])uniqueKeys)) {
            for (String uniqueKey : uniqueKeys) {
                Object uniqueValue = sortJson.get((Object)uniqueKey);
                paramJson.put(uniqueKey, uniqueValue);
            }
        }
        paramJson.put("sort_idx", updateSortList);
        List<JSONObject> list = this.list(tableName, paramJson);
        JSONArray paramJsonArray = new JSONArray();
        for (JSONObject actionJSON : list) {
            Long actionId = actionJSON.getLong("id");
            Long actionSort = actionJSON.getLong("sort_idx");
            actionSort = isASC ? Long.valueOf(actionSort - 1L) : Long.valueOf(actionSort + 1L);
            JSONObject actionParamJSON = new JSONObject();
            actionParamJSON.put("id", (Object)actionId);
            actionParamJSON.put("sort_idx", (Object)actionSort);
            paramJsonArray.add((Object)actionParamJSON);
        }
        JSONObject updateSortParam = new JSONObject();
        updateSortParam.put("id", (Object)id);
        updateSortParam.put("sort_idx", (Object)updateSortIdx);
        paramJsonArray.add((Object)updateSortParam);
        this.updateById(tableName, ListUtils.toJsons((JSONArray)paramJsonArray), DbUpdateEnum.NORMAL);
    }

    @Transactional
    public void updateBatch(String tableName, JSONObject[] paramJsons, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        for (JSONObject paramJson : paramJsons) {
            this.paramFormat(paramJson);
        }
        this.updateBatchNotParamFormat(tableName, paramJsons, conditions, dBUpdateEnum);
    }

    @Transactional
    public void updateBatchNotParamFormat(String tableName, JSONObject[] paramJsons, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        String sql = this.updateSqlBuild(tableName, paramJsons[0], conditions, dBUpdateEnum);
        int[] updateRowsNumberArray = this.getNamedParameterJdbcTemplate().batchUpdate(sql, (Map[])paramJsons);
        int expectedValue = 1;
        this.updateBatchAndExpectedEqual(updateRowsNumberArray, expectedValue);
    }
}

