/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.jdbc.client.dialect.impl;

import ai.yue.library.base.constant.SortEnum;
import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.util.ArithCompute;
import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.data.jdbc.client.DbBase;
import ai.yue.library.data.jdbc.client.dialect.Dialect;
import ai.yue.library.data.jdbc.client.dialect.DialectNameEnum;
import ai.yue.library.data.jdbc.client.dialect.Wrapper;
import ai.yue.library.data.jdbc.client.dialect.impl.MysqlDialect;
import ai.yue.library.data.jdbc.config.properties.JdbcProperties;
import ai.yue.library.data.jdbc.constant.DbUpdateEnum;
import ai.yue.library.data.jdbc.ipo.Page;
import ai.yue.library.data.jdbc.ipo.PageIPO;
import ai.yue.library.data.jdbc.vo.PageVO;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.lang.Nullable;

public class AnsiDialect
extends DbBase
implements Dialect {
    private static final Logger log = LoggerFactory.getLogger(AnsiDialect.class);
    private static final long serialVersionUID = 1841162445914907750L;
    protected Wrapper wrapper = new Wrapper();
    protected JdbcProperties jdbcProperties;
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public AnsiDialect(NamedParameterJdbcTemplate namedParameterJdbcTemplate, JdbcProperties jdbcProperties) {
        this.dialect = this;
        this.jdbcProperties = jdbcProperties;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    @Override
    public Dialect cloneDialect() {
        return this.clone();
    }

    public AnsiDialect clone() {
        log.info("\u6267\u884c{}\uff0c\u6df1\u5ea6\u514b\u9686\u3002", this.getClass());
        DataSource dataSource = (DataSource)ObjectUtils.cloneIfPossible((Object)this.getNamedParameterJdbcTemplate().getJdbcTemplate().getDataSource());
        return new MysqlDialect(new NamedParameterJdbcTemplate(dataSource), this.jdbcProperties.clone());
    }

    @Override
    public DialectNameEnum dialectName() {
        return DialectNameEnum.ANSI;
    }

    @Override
    public String getPageJoinSql() {
        return new StringBuffer().append(" ").append("LIMIT").append(" ").append(":page").append(" , ").append(":limit").append(" ").toString();
    }

    @Override
    public Long insertOrUpdate(String tableName, JSONObject paramJson, String[] conditions, DbUpdateEnum dBUpdateEnum) {
        String key;
        this.paramValidate(tableName, paramJson, conditions);
        this.paramFormat(paramJson);
        tableName = this.wrapper.wrap(tableName);
        paramJson = this.wrapper.wrap(paramJson);
        conditions = this.wrapper.wrap(conditions);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        sql.append(" (");
        Set keys = paramJson.keySet();
        Iterator it = keys.iterator();
        Iterator iterator = keys.iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            sql.append(key);
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") VALUES (");
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            sql.append(":");
            sql.append(key);
            if (!iterator.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") ON DUPLICATE KEY UPDATE ");
        for (String condition : conditions) {
            sql.append(condition);
            sql.append(" = ");
            if (dBUpdateEnum == DbUpdateEnum.NORMAL) {
                sql.append(":" + condition);
            } else {
                sql.append(condition);
                if (dBUpdateEnum == DbUpdateEnum.INCREMENT) {
                    sql.append(" + :");
                } else {
                    sql.append(" - :");
                }
                sql.append(condition);
            }
            sql.append(", ");
        }
        sql = new StringBuffer(StringUtils.deleteLastEqualString((CharSequence)sql, (CharSequence)", "));
        return this.namedParameterJdbcTemplate.update(sql.toString(), (Map)paramJson);
    }

    @Override
    public Page toPage(PageIPO pageIPO) {
        long page = pageIPO.getPage().intValue();
        int limit = pageIPO.getLimit();
        JSONObject conditions = pageIPO.getConditions();
        if (--page >= 1L) {
            page = (long)ArithCompute.mul((double)page, (double)limit);
        }
        return Page.builder().page(page).limit(limit).conditions(conditions).build();
    }

    @Override
    public <T> PageVO<T> page(String tableName, PageIPO pageIPO, SortEnum sortEnum, Class<T> mappedClass) {
        this.paramValidate(tableName);
        JSONObject conditions = pageIPO.getConditions();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT a.* FROM ");
        querySql.append(tableName + " a, ");
        querySql.append("(SELECT id FROM ");
        querySql.append(tableName);
        String whereSql = "";
        if (conditions != null) {
            whereSql = this.paramToWhereSql(conditions);
        }
        querySql.append(whereSql);
        if (sortEnum == null) {
            querySql.append(this.getPageJoinSql()).append(") b WHERE a.id = b.id");
        } else if (SortEnum.ASC == sortEnum) {
            querySql.append(" ORDER BY ").append("id").append(this.getPageJoinSql()).append(") b WHERE a.id = b.id");
        } else {
            querySql.append(" ORDER BY ").append("id").append(" DESC ").append(this.getPageJoinSql()).append(") b WHERE a.id = b.id");
        }
        StringBuffer countSql = new StringBuffer();
        countSql.append("SELECT count(*) count FROM ");
        countSql.append(tableName);
        countSql.append(whereSql);
        return this.pageSql(countSql.toString(), querySql.toString(), pageIPO, mappedClass);
    }

    @Override
    public <T> PageVO<T> pageWhere(String tableName, String whereSql, PageIPO pageIPO, Class<T> mappedClass) {
        this.paramValidate(tableName, whereSql);
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT a.* FROM ");
        querySql.append(tableName + " a, ");
        querySql.append(" (SELECT id FROM ");
        querySql.append(tableName);
        querySql.append(" ");
        querySql.append(whereSql);
        querySql.append(this.getPageJoinSql()).append(") b WHERE a.id = b.id");
        StringBuffer countSql = new StringBuffer();
        countSql.append("SELECT count(*) count FROM ");
        countSql.append(tableName);
        countSql.append(" ");
        countSql.append(whereSql);
        return this.pageSql(countSql.toString(), querySql.toString(), pageIPO, mappedClass);
    }

    @Override
    public <T> PageVO<T> pageSql(String querySql, PageIPO pageIPO, Class<T> mappedClass) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DbException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int fromIndex = querySql.toUpperCase().indexOf("FROM");
        String countStr = "SELECT count(*) count " + querySql.substring(fromIndex);
        int limitIndex = countStr.toUpperCase().indexOf("LIMIT");
        if (-1 == limitIndex) {
            throw new DbException("querySql\u4e0d\u80fd\u6ca1\u6709LIMIT");
        }
        int EndIndex = countStr.indexOf(")", limitIndex);
        if (-1 == EndIndex) {
            System.err.println("\u9519\u8bef\u7684querySql\uff1a\n");
            System.err.println(querySql);
            throw new DbException("querySql\u5e94\u5f53\u662f\u4e00\u4e2a\u4f18\u5316\u540e\u7684\u8bed\u53e5\uff0c\u5176\u4e2dLIMIT\u5fc5\u987b\u653e\u5728\u5b50\u67e5\u8be2\u5185\uff0c\u8be6\u7ec6\u8bf7\u53c2\u7167\u793a\u4f8b\u8bed\u53e5\u7f16\u5199\u3002");
        }
        StringBuffer countSql = new StringBuffer(countStr);
        countSql = countSql.delete(limitIndex, EndIndex);
        return this.pageSql(countSql.toString(), querySql, pageIPO, mappedClass);
    }

    @Override
    public <T> PageVO<T> pageSql(@Nullable String countSql, String querySql, PageIPO pageIPO, Class<T> mappedClass) {
        if (StringUtils.isEmpty((CharSequence)querySql)) {
            throw new DbException("querySql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject paramJson = this.toPage(pageIPO).toParamJson();
        JSONObject conditions = pageIPO.getConditions();
        Long count = null;
        if (StringUtils.isNotEmpty((CharSequence)countSql)) {
            count = this.queryForObject(countSql, conditions, Long.class);
        }
        List<Object> data = new ArrayList();
        if (count == null || count != 0L) {
            data = this.queryForList(querySql, paramJson, mappedClass);
        }
        PageVO pageVO = new PageVO();
        return pageVO.toBuilder().count(count).data(data).build();
    }

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public JdbcProperties getJdbcProperties() {
        return this.jdbcProperties;
    }

    @Override
    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void setJdbcProperties(JdbcProperties jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
    }

    @Override
    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

