/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.redis.client;

import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.view.ResultInfo;
import ai.yue.library.data.redis.config.properties.WxMaProperties;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.WxMaInMemoryConfig;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WxMaProperties.class})
@ConditionalOnProperty(prefix="yue.wx.miniapp", name={"enabled"}, havingValue="true")
public class WxMaUser {
    @Autowired
    private WxMaProperties wxMaProperties;
    private Map<String, WxMaService> maServices = Maps.newHashMap();

    @PostConstruct
    private void init() {
        List<WxMaProperties.Config> configs = this.wxMaProperties.getConfigs();
        if (ListUtils.isEmpty(configs)) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5c0f\u7a0b\u5e8f\u914d\u7f6e...");
        }
        this.maServices = configs.stream().map(a -> {
            WxMaInMemoryConfig config = new WxMaInMemoryConfig();
            config.setAppid(a.getAppid());
            config.setSecret(a.getSecret());
            WxMaServiceImpl service = new WxMaServiceImpl();
            service.setWxMaConfig((WxMaConfig)config);
            return service;
        }).collect(Collectors.toMap(s -> s.getWxMaConfig().getAppid(), a -> a));
    }

    private WxMaService getMaService(String appid) {
        WxMaService wxService = this.maServices.get(appid);
        if (wxService == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94appid=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", appid));
        }
        return wxService;
    }

    public WxMaJscode2SessionResult getSessionInfo(String appid, String code) {
        WxMaService wxService = this.getMaService(appid);
        WxMaJscode2SessionResult wxMaJscode2SessionResult = null;
        try {
            wxMaJscode2SessionResult = wxService.getUserService().getSessionInfo(code);
        }
        catch (WxErrorException e) {
            String msg = e.getMessage();
            throw new ResultException(ResultInfo.dev_defined((String)msg));
        }
        return wxMaJscode2SessionResult;
    }

    public WxMaUserInfo getUserInfo(String appid, String sessionKey, String signature, String rawData, String encryptedData, String iv) {
        WxMaService wxService = this.getMaService(appid);
        if (!wxService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            throw new ParamException("user check failed");
        }
        WxMaUserInfo wxMaUserInfo = wxService.getUserService().getUserInfo(sessionKey, encryptedData, iv);
        return wxMaUserInfo;
    }

    public WxMaPhoneNumberInfo getCellphone(String appid, String sessionKey, String encryptedData, String iv) {
        WxMaService wxService = this.getMaService(appid);
        WxMaPhoneNumberInfo wxMaPhoneNumberInfo = wxService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, iv);
        return wxMaPhoneNumberInfo;
    }
}

