/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.redis.client;

import ai.yue.library.base.config.properties.ConstantProperties;
import ai.yue.library.base.exception.LoginException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.ipo.CaptchaIPO;
import ai.yue.library.base.util.CaptchaUtils;
import ai.yue.library.base.util.CookieUtils;
import ai.yue.library.base.util.HttpUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.base.view.Result;
import ai.yue.library.base.view.ResultInfo;
import ai.yue.library.base.vo.CaptchaVO;
import ai.yue.library.data.redis.client.Redis;
import ai.yue.library.data.redis.config.properties.QqProperties;
import ai.yue.library.data.redis.config.properties.WxOpenProperties;
import ai.yue.library.data.redis.dto.QqUserDTO;
import ai.yue.library.data.redis.dto.WxUserDTO;
import ai.yue.library.data.redis.vo.wx.open.AccessTokenVO;
import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class User {
    @Autowired
    Redis redis;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    HttpServletRequest request;
    @Autowired
    HttpServletResponse response;
    @Autowired
    ConstantProperties constantProperties;
    @Autowired
    WxOpenProperties wxOpenProperties;
    @Autowired
    QqProperties qqProperties;
    private static final String WX_URI_ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={appid}&secret={secret}&code={code}&grant_type=authorization_code";
    private static final String WX_URI_USER_INFO = "https://api.weixin.qq.com/sns/userinfo?access_token={access_token}&openid={openid}";
    private static final String QQ_URI_USER_INFO = "https://graph.qq.com/user/get_user_info?oauth_consumer_key={oauth_consumer_key}&access_token={access_token}&openid={openid}";

    public AccessTokenVO getWxAccessToken(String code) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("appid", (Object)this.wxOpenProperties.getAppid());
        paramJson.put("secret", (Object)this.wxOpenProperties.getSecret());
        paramJson.put("code", (Object)code);
        String result = (String)this.restTemplate.getForObject(WX_URI_ACCESS_TOKEN, String.class, (Map)paramJson);
        AccessTokenVO accessTokenVO = (AccessTokenVO)JSONObject.parseObject((String)result, AccessTokenVO.class);
        return accessTokenVO;
    }

    public WxUserDTO getWxUserInfo(String access_token, String openid) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("access_token", (Object)access_token);
        paramJson.put("openid", (Object)openid);
        String result = (String)this.restTemplate.getForObject(WX_URI_USER_INFO, String.class, (Map)paramJson);
        WxUserDTO wxUserDTO = (WxUserDTO)JSONObject.parseObject((String)result, WxUserDTO.class);
        if (null == wxUserDTO.getOpenid()) {
            throw new ResultException(ResultInfo.error((Object)result));
        }
        return wxUserDTO;
    }

    public QqUserDTO getQqUserInfo(String access_token, String openid) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("oauth_consumer_key", (Object)this.qqProperties.getQq_appid());
        paramJson.put("access_token", (Object)access_token);
        paramJson.put("openid", (Object)openid);
        String result = (String)this.restTemplate.getForObject(QQ_URI_USER_INFO, String.class, (Map)paramJson);
        QqUserDTO qqUserDTO = (QqUserDTO)JSONObject.parseObject((String)result, QqUserDTO.class);
        if (null == qqUserDTO.getGender()) {
            throw new ResultException(ResultInfo.error((Object)result));
        }
        return qqUserDTO;
    }

    public void getCaptchaImage() {
        CaptchaVO captchaVO = CaptchaUtils.createCaptchaImage((CaptchaIPO)CaptchaIPO.builder().build());
        String captcha = captchaVO.getCaptcha();
        BufferedImage captchaImage = captchaVO.getCaptchaImage();
        String captcha_redis_key = String.format("captcha_%s", captcha);
        this.redis.set(captcha_redis_key, captcha, (long)this.constantProperties.getCaptcha_timeout().intValue());
        HttpServletResponse response = HttpUtils.getResponse();
        response.setContentType("image/png");
        try {
            ServletOutputStream output = response.getOutputStream();
            ImageIO.write((RenderedImage)captchaImage, "png", (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void captchaValidate(String captcha) {
        String captcha_redis_key = String.format("captcha_%s", captcha);
        String randCaptcha = this.redis.get(captcha_redis_key);
        if (StringUtils.isEmpty((CharSequence)randCaptcha) || !randCaptcha.equalsIgnoreCase(captcha)) {
            throw new ResultException(ResultInfo.captcha_error());
        }
        this.redis.del(captcha_redis_key);
    }

    private String getRequestToken() {
        Cookie cookie = CookieUtils.get((String)"token");
        String token = "";
        token = cookie != null ? cookie.getValue() : this.request.getHeader("token");
        return token;
    }

    public Long getUserId() {
        try {
            String token = this.getRequestToken();
            if (StringUtils.isEmpty((CharSequence)token)) {
                throw new LoginException("token == null");
            }
            String tokenValue = this.redis.get(String.format("token_%s", token));
            return JSONObject.parseObject((String)tokenValue).getLong("user_id");
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public <T> T getUser(Class<T> clazz) {
        try {
            String token = this.getRequestToken();
            if (StringUtils.isEmpty((CharSequence)token)) {
                throw new LoginException("token == null");
            }
            String tokenValue = this.redis.get(String.format("token_%s", token));
            Object t = JSONObject.parseObject((String)tokenValue, clazz);
            if (t == null) {
                throw new LoginException(null);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public String login(Object userInfo) {
        String tokenValue;
        String token = this.getRequestToken();
        String redis_token_key = null;
        if (StringUtils.isNotEmpty((CharSequence)token) && StringUtils.isNotEmpty((CharSequence)(tokenValue = this.redis.get(redis_token_key = String.format("token_%s", token))))) {
            this.redis.del(redis_token_key);
        }
        token = UUID.randomUUID().toString();
        redis_token_key = String.format("token_%s", token);
        Integer tokenTimeout = this.constantProperties.getToken_timeout();
        this.redis.set(redis_token_key, userInfo, (long)tokenTimeout.intValue());
        CookieUtils.set((String)"token", (String)token, (int)tokenTimeout);
        this.response.setHeader("token", token);
        return token;
    }

    public Result<?> logout() {
        String token = this.getRequestToken();
        if (StringUtils.isEmpty((CharSequence)token)) {
            return ResultInfo.unauthorized();
        }
        this.redis.del(String.format("token_%s", token));
        CookieUtils.set((String)"token", null, (int)0);
        return ResultInfo.success();
    }
}

