/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.redis.idempotent;

import ai.yue.library.base.annotation.api.version.ApiVersion;
import ai.yue.library.base.util.IdUtils;
import ai.yue.library.base.view.R;
import ai.yue.library.base.view.Result;
import ai.yue.library.data.redis.client.Redis;
import ai.yue.library.data.redis.constant.RedisConstant;
import ai.yue.library.data.redis.idempotent.ApiIdempotentProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiVersion(value=2.3)
@RestController
@RequestMapping(value={"/open/{version}/apiIdempotent"})
@EnableConfigurationProperties(value={ApiIdempotentProperties.class})
@ConditionalOnProperty(prefix="yue.redisapi-idempotent", name={"enabled"}, havingValue="true")
public class ApiIdempotentController {
    @Autowired
    ApiIdempotentProperties apiIdempotentProperties;
    @Autowired
    Redis redis;

    @GetMapping(value={"/getVersion"})
    public Result<?> getVersion() {
        String version = IdUtils.getSimpleUUID();
        String key = RedisConstant.API_IDEMPOTENT_KEY_PREFIX + version;
        this.redis.set(key, version, (long)this.apiIdempotentProperties.getVersionTimeout());
        return R.success((Object)version);
    }
}

