/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.redis.client;

import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.util.StringUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class Redis {
    private static final Logger log = LoggerFactory.getLogger(Redis.class);
    RedisTemplate<String, Object> redisTemplate;
    StringRedisTemplate stringRedisTemplate;

    public boolean lock(String lockKey, Long lockTimeout) {
        String oldValue;
        String value = lockTimeout.toString();
        if (this.stringRedisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)value).booleanValue()) {
            return true;
        }
        String currentValue = (String)this.stringRedisTemplate.opsForValue().get((Object)lockKey);
        return !StringUtils.isEmpty((CharSequence)currentValue) && Long.parseLong(currentValue) < System.currentTimeMillis() && !StringUtils.isEmpty((CharSequence)(oldValue = (String)this.stringRedisTemplate.opsForValue().getAndSet((Object)lockKey, (Object)value))) && oldValue.equals(currentValue);
    }

    public void unlock(String lockKey, Long lockTimeout) {
        String value = lockTimeout.toString();
        try {
            String currentValue = (String)this.stringRedisTemplate.opsForValue().get((Object)lockKey);
            if (StringUtils.isNotEmpty((CharSequence)currentValue) && currentValue.equals(value)) {
                this.stringRedisTemplate.opsForValue().getOperations().delete((Object)lockKey);
            }
        }
        catch (Exception e) {
            log.error("\u3010redis\u5206\u5e03\u5f0f\u9501\u3011\u89e3\u9501\u5f02\u5e38\uff0c{}", (Throwable)e);
        }
    }

    public long ttl(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public void expire(String key, long timeout) {
        this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public long incr(String key, long delta) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }

    public void del(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public void set(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void set(String key, Object value, long timeout) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout, TimeUnit.SECONDS);
    }

    public void set(String key, String value, long timeout) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public Object getObject(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public <T> T get(String key, Class<T> clazz) {
        return (T)Convert.convert((Object)this.redisTemplate.opsForValue().get((Object)key), clazz);
    }

    public void hset(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    public Object hget(String key, String hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    public <T> T hget(String key, String hashKey, Class<T> clazz) {
        return (T)Convert.convert((Object)this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey), clazz);
    }

    public void hdel(String key, Object ... hashKeys) {
        this.redisTemplate.opsForHash().delete((Object)key, hashKeys);
    }

    public Map<Object, Object> hgetall(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public long lpush(String key, String value) {
        return this.stringRedisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public long rpush(String key, String value) {
        return this.stringRedisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    public String lpop(String key) {
        return (String)this.stringRedisTemplate.opsForList().leftPop((Object)key);
    }

    public static String separatorJoin(String ... elements) {
        return String.join((CharSequence)":", elements);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Redis)) {
            return false;
        }
        Redis other = (Redis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, Object> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, Object> other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        StringRedisTemplate this$stringRedisTemplate = this.getStringRedisTemplate();
        StringRedisTemplate other$stringRedisTemplate = other.getStringRedisTemplate();
        return !(this$stringRedisTemplate == null ? other$stringRedisTemplate != null : !this$stringRedisTemplate.equals(other$stringRedisTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Redis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, Object> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        StringRedisTemplate $stringRedisTemplate = this.getStringRedisTemplate();
        result = result * 59 + ($stringRedisTemplate == null ? 43 : $stringRedisTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "Redis(redisTemplate=" + this.getRedisTemplate() + ", stringRedisTemplate=" + this.getStringRedisTemplate() + ")";
    }

    public Redis(RedisTemplate<String, Object> redisTemplate, StringRedisTemplate stringRedisTemplate) {
        this.redisTemplate = redisTemplate;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

