/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.redis.config;

import ai.yue.library.base.util.ClassUtils;
import ai.yue.library.data.redis.client.Redis;
import ai.yue.library.data.redis.config.properties.RedisProperties;
import ai.yue.library.data.redis.constant.RedisSerializerEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedisAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(RedisAutoConfig.class);
    @Autowired
    RedisProperties redisProperties;

    @Bean
    public RedisTemplate<String, Object> yueRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        if (this.redisProperties.getRedisSerializer() != RedisSerializerEnum.JDK) {
            redisTemplate.setDefaultSerializer(this.redisProperties.getRedisSerializer().getRedisSerializer());
        }
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        return redisTemplate;
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={RedisTemplate.class, StringRedisTemplate.class})
    public Redis redis(@Qualifier(value="yueRedisTemplate") RedisTemplate<String, Object> redisTemplate, StringRedisTemplate stringRedisTemplate) {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-Redis\u5ba2\u6237\u7aef\u3011\u914d\u7f6e\u9879\uff1a{}\uff0c\u9ed8\u8ba4\u4f7f\u7528 {} \u8fdb\u884cRedis\u5b58\u50a8\u5bf9\u8c61\u5e8f\u5217/\u53cd\u5e8f\u5217\u5316\u3002Bean\uff1aRedis ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002", (Object)"yue.redis", (Object)ClassUtils.getClassName(RedisSerializerEnum.class, (boolean)false).concat(".JDK"));
        return new Redis(redisTemplate, stringRedisTemplate);
    }
}

