/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.pay.util;

import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ApplicationContextUtils;
import ai.yue.library.base.view.ResultInfo;
import ai.yue.library.pay.dto.ApplePayVerifyResult;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.client.RestTemplate;

public class ApplePayUtils {
    private static RestTemplate restTemplate = (RestTemplate)ApplicationContextUtils.getBean(RestTemplate.class);
    private static final String URI_SANDBOX = "https://sandbox.itunes.apple.com/verifyReceipt";
    private static final String URI_VERIFY = "https://buy.itunes.apple.com/verifyReceipt";

    public static ApplePayVerifyResult verify(String receiptData) {
        return ApplePayUtils.verify(URI_VERIFY, receiptData);
    }

    private static ApplePayVerifyResult verify(String uri, String receiptData) {
        JSONObject requestData = new JSONObject();
        requestData.put("receipt-data", (Object)receiptData);
        String response = (String)restTemplate.postForObject(uri, (Object)requestData, String.class, new Object[0]);
        JSONObject result = JSONObject.parseObject((String)response);
        Integer status = result.getInteger("status");
        if (status == 21007) {
            return ApplePayUtils.verify(URI_SANDBOX, receiptData);
        }
        if (status != 0) {
            throw new ResultException(ResultInfo.error((Object)response));
        }
        JSONObject receipt = result.getJSONObject("receipt");
        JSONObject in_app = receipt.getJSONArray("in_app").getJSONObject(0);
        String transaction_id = in_app.getString("transaction_id");
        String product_id = in_app.getString("product_id");
        Integer quantity = in_app.getInteger("quantity");
        String purchase_date = in_app.getString("purchase_date");
        return ApplePayVerifyResult.builder().status(status).transaction_id(transaction_id).product_id(product_id).quantity(quantity).purchase_date(purchase_date).build();
    }
}

