/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.grpc.config.exception;

import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.exception.ApiVersionDeprecatedException;
import ai.yue.library.base.exception.AttackException;
import ai.yue.library.base.exception.ClientFallbackException;
import ai.yue.library.base.exception.DbException;
import ai.yue.library.base.exception.ForbiddenException;
import ai.yue.library.base.exception.LoginException;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ExceptionUtils;
import ai.yue.library.base.view.R;
import ai.yue.library.base.view.Result;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.List;
import net.devh.boot.grpc.server.advice.GrpcAdvice;
import net.devh.boot.grpc.server.advice.GrpcExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.validation.BindException;

@GrpcAdvice
@ConditionalOnProperty(prefix="yue.exception-handler", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ResultExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultExceptionHandler.class);

    @GrpcExceptionHandler(value={Exception.class})
    public synchronized Status exceptionHandler(Exception e) {
        Status status = Status.INTERNAL;
        ExceptionUtils.printException((Throwable)e);
        return status.withDescription(R.getResult((Throwable)e).castToJSONString());
    }

    @GrpcExceptionHandler(value={ResultException.class})
    public synchronized Status resultExceptionHandler(ResultException e) {
        Result result = e.getResult();
        log.error(result.toString());
        ExceptionUtils.printException((Throwable)e);
        Integer code = result.getCode();
        Status status = null;
        if (code >= 400 && code < 500) {
            status = Status.INVALID_ARGUMENT;
        } else if (code >= 500 && code < 600) {
            status = Status.INTERNAL;
        } else if (code == 600) {
            status = Status.UNIMPLEMENTED;
        } else {
            status = Status.INTERNAL;
            String dataPrompt = StrUtil.format((CharSequence)"\u9519\u8bef\u7684\u4f7f\u7528RESTful code\uff1a4xx\u5ba2\u6237\u7aef\u9519\u8bef\u30015xx\u670d\u52a1\u7aef\u9519\u8bef\u3001600\u4e1a\u52a1\u63d0\u793a\uff0c\u5f53\u524dcode\u7801\u4e3a{}\uff0c\u4e0d\u5e94\u8be5\u5728\u5f02\u5e38\u54cd\u5e94\u4e2d\u51fa\u73b0\uff0c\u8bf7\u6392\u67e5\u3002", (Object[])new Object[]{code});
            result = R.internalServerError((Object)dataPrompt);
        }
        return status.withDescription(result.castToJSONString());
    }

    @GrpcExceptionHandler(value={LoginException.class})
    public Status loginExceptionHandler(LoginException e) {
        ExceptionUtils.printException((Throwable)e);
        Status status = Status.INVALID_ARGUMENT;
        return status.withDescription(R.unauthorized().castToJSONString());
    }

    @GrpcExceptionHandler(value={AttackException.class})
    public Status attackExceptionHandler(AttackException e) {
        ExceptionUtils.printException((Throwable)e);
        Status status = Status.INVALID_ARGUMENT;
        return status.withDescription(R.attack((Object)e.getMessage()).castToJSONString());
    }

    @GrpcExceptionHandler(value={ForbiddenException.class})
    public Status forbiddenExceptionHandler(ForbiddenException e) {
        ExceptionUtils.printException((Throwable)e);
        Status status = Status.INVALID_ARGUMENT;
        return status.withDescription(R.forbidden().castToJSONString());
    }

    @GrpcExceptionHandler(value={ApiVersionDeprecatedException.class})
    public Status apiVersionDeprecatedExceptionHandler(ApiVersionDeprecatedException e) {
        ExceptionUtils.printException((Throwable)e);
        Status status = Status.INVALID_ARGUMENT;
        return status.withDescription(R.gone().castToJSONString());
    }

    @GrpcExceptionHandler(value={ParamVoidException.class})
    public Status paramVoidExceptionHandler() {
        Status status = Status.INVALID_ARGUMENT;
        return status.withDescription(R.paramVoid().castToJSONString());
    }

    @GrpcExceptionHandler(value={ParamException.class})
    public Status paramExceptionHandler(ParamException e) {
        ExceptionUtils.printException((Throwable)e);
        Status status = Status.INVALID_ARGUMENT;
        return status.withDescription(R.paramCheckNotPass((Object)e.getMessage()).castToJSONString());
    }

    @GrpcExceptionHandler(value={BindException.class})
    public Status bindExceptionHandler(BindException e) {
        List errors = e.getAllErrors();
        JSONObject paramHint = new JSONObject();
        errors.forEach(error -> {
            String str = StrUtil.subAfter((CharSequence)error.getArguments()[0].toString(), (CharSequence)"[", (boolean)true);
            String key = str.substring(0, str.length() - 1);
            String msg = error.getDefaultMessage();
            paramHint.put(key, (Object)msg);
            Console.error((Object)(key + " " + msg));
        });
        Status status = Status.INVALID_ARGUMENT;
        return status.withDescription(R.paramCheckNotPass((Object)paramHint).castToJSONString());
    }

    @GrpcExceptionHandler(value={ValidateException.class})
    public Status validateExceptionHandler(ValidateException e) {
        ExceptionUtils.printException((Throwable)e);
        Result result = null;
        try {
            result = R.paramCheckNotPass((Object)Convert.toJSONArray((Object)e.getMessage()));
        }
        catch (Exception exception) {
            result = R.paramCheckNotPass((Object)e.getMessage());
        }
        Status status = Status.INVALID_ARGUMENT;
        return status.withDescription(result.castToJSONString());
    }

    @GrpcExceptionHandler(value={DbException.class})
    public Status dbExceptionHandler(DbException e) {
        e.printStackTrace();
        Result result = null;
        result = e.isShowMsg() ? R.dbError((Object)e.getMessage()) : R.dbError();
        Status status = Status.INTERNAL;
        return status.withDescription(result.castToJSONString());
    }

    @GrpcExceptionHandler(value={ClientFallbackException.class})
    public Status clientFallbackExceptionHandler(ClientFallbackException e) {
        ExceptionUtils.printException((Throwable)e);
        Status status = Status.INTERNAL;
        return status.withDescription(R.clientFallback().castToJSONString());
    }

    @GrpcExceptionHandler(value={StatusRuntimeException.class})
    public Status statusRuntimeExceptionHandler(StatusRuntimeException e) {
        ExceptionUtils.printException((Throwable)e);
        Status status = Status.INTERNAL;
        return status.withDescription(R.clientFallback().castToJSONString());
    }

    @GrpcExceptionHandler(value={ConvertException.class})
    public Status convertExceptionHandler(ConvertException e) {
        log.error("\u3010\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\u3011\u8f6c\u6362\u7c7b\u578b\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException((Throwable)e);
        Status status = Status.INTERNAL;
        return status.withDescription(R.typeConvertError((Object)e.getMessage()).castToJSONString());
    }
}

