/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.config;

import ai.yue.library.base.config.properties.CorsProperties;
import ai.yue.library.base.config.thread.pool.AsyncProperties;
import ai.yue.library.web.config.WebMvcConfig;
import ai.yue.library.web.config.WebMvcRegistrationsConfig;
import ai.yue.library.web.config.argument.resolver.CustomArgumentResolversConfig;
import ai.yue.library.web.config.argument.resolver.RepeatedlyReadServletRequestFilter;
import ai.yue.library.web.config.properties.FastJsonHttpMessageConverterProperties;
import ai.yue.library.web.config.properties.JacksonHttpMessageConverterProperties;
import ai.yue.library.web.config.properties.WebProperties;
import ai.yue.library.web.config.thread.pool.ContextDecorator;
import ai.yue.library.web.env.WebMvcEnv;
import ai.yue.library.web.util.servlet.multipart.UploadProperties;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@Import(value={WebMvcConfig.class, WebMvcRegistrationsConfig.class, CustomArgumentResolversConfig.class, WebMvcEnv.class})
@EnableConfigurationProperties(value={WebProperties.class, JacksonHttpMessageConverterProperties.class, FastJsonHttpMessageConverterProperties.class, UploadProperties.class})
public class WebAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(WebAutoConfig.class);
    @Autowired
    WebProperties webProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="yue.cors", name={"allow"}, havingValue="true", matchIfMissing=true)
    public CorsFilter corsFilter(CorsProperties corsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.setAllowedHeaders(Arrays.asList("*"));
        config.setAllowedMethods(Arrays.asList("*"));
        config.setAllowedOrigins(Arrays.asList("*"));
        config.setMaxAge(Long.valueOf(3600L));
        List exposedHeaders = corsProperties.getExposedHeaders();
        if (exposedHeaders != null) {
            config.setExposedHeaders(exposedHeaders);
        } else {
            config.addExposedHeader("token");
        }
        source.registerCorsConfiguration("/**", config);
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u8de8\u57df\u3011\u9ed8\u8ba4\u914d\u7f6e\u4e3atrue\uff0c\u5f53\u524d\u73af\u5883\u4e3atrue\uff1a\u9ed8\u8ba4\u4efb\u4f55\u60c5\u51b5\u4e0b\u90fd\u5141\u8bb8\u8de8\u57df\u8bbf\u95ee ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    @ConditionalOnProperty(prefix="yue.web", name={"enabled-repeatedly-read-servlet-request"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<RepeatedlyReadServletRequestFilter> registerRepeatedlyReadRequestFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(this.webProperties.getRepeatedlyReadServletRequestFilterOrder());
        filterRegistrationBean.setFilter((Filter)new RepeatedlyReadServletRequestFilter());
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-HttpServletRequest\u3011\u9ed8\u8ba4\u914d\u7f6e\u4e3atrue\uff0c\u5f53\u524d\u73af\u5883\u4e3atrue\uff1a\u9ed8\u8ba4\u542f\u7528\u8f93\u5165\u6d41\u53ef\u53cd\u590d\u8bfb\u53d6\u7684HttpServletRequest ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AsyncProperties.class})
    public ContextDecorator contextDecorator(AsyncProperties asyncProperties) {
        return new ContextDecorator(asyncProperties);
    }
}

