/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.config.idempotent;

import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.base.view.R;
import ai.yue.library.data.redis.client.Redis;
import ai.yue.library.data.redis.constant.RedisConstant;
import ai.yue.library.data.redis.idempotent.ApiIdempotent;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@ConditionalOnBean(value={Redis.class})
public class IdempotentInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(IdempotentInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        ApiIdempotent methodAnnotation = method.getAnnotation(ApiIdempotent.class);
        if (methodAnnotation != null) {
            this.checkApiIdempotent(request);
        }
        return true;
    }

    private void checkApiIdempotent(HttpServletRequest request) {
        String version = request.getHeader("apiIdempotentVersion");
        if (StrUtil.isBlank((CharSequence)version) && StrUtil.isBlank((CharSequence)(version = request.getParameter("apiIdempotentVersion")))) {
            throw new ParamException(StrUtil.format((CharSequence)"\u3010\u5e42\u7b49\u6027\u3011\u5e42\u7b49\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u6c42\u4e2d\u672a\u5305\u542b {} \u53c2\u6570", (Object[])new Object[]{"apiIdempotentVersion"}));
        }
        Redis redis = (Redis)SpringUtils.getBean(Redis.class);
        String redisKey = RedisConstant.API_IDEMPOTENT_KEY_PREFIX + version;
        if (!redis.getRedisTemplate().hasKey((Object)redisKey).booleanValue()) {
            String msgPrompt = "\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c";
            String dataPrompt = StrUtil.format((CharSequence)"\u3010\u5e42\u7b49\u6027\u3011\u5e42\u7b49\u6821\u9a8c\u5931\u8d25\uff0c{} \u53c2\u6570\u5df2\u5931\u6548\uff0c\u5f53\u524d value: {}", (Object[])new Object[]{"apiIdempotentVersion", version});
            throw new ResultException(R.errorPrompt((String)msgPrompt, (Object)dataPrompt));
        }
        if (!redis.del(redisKey).booleanValue()) {
            log.warn("\u3010\u5e42\u7b49\u6027\u3011\u5e42\u7b49\u6821\u9a8c\u5931\u8d25\uff0c{} \u53c2\u6570\u672a\u80fd\u6b63\u786e\u7684\u89e3\u9501", (Object)redisKey);
        }
    }
}

