/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.config.thread.pool;

import ai.yue.library.base.config.thread.pool.AsyncProperties;
import ai.yue.library.web.config.thread.pool.AbstractContextDecorator;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ContextDecorator
extends AbstractContextDecorator {
    public ContextDecorator(AsyncProperties asyncProperties) {
        super(asyncProperties);
    }

    public Runnable decorate(Runnable runnable) {
        ServletRequestAttributes context = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Map previous = MDC.getCopyOfContextMap();
        this.enableServletAsyncContext(context, this.asyncProperties);
        return () -> {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)context);
                if (previous != null) {
                    MDC.setContextMap((Map)previous);
                }
                runnable.run();
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
                MDC.clear();
                this.completeServletAsyncContext(context, this.asyncProperties);
            }
        };
    }
}

