/*
 * Decompiled with CFR 0.152.
 */
package al.aldi.sprova4j;

import al.aldi.sprova4j.SprovaApiClient;
import al.aldi.sprova4j.exections.SprovaClientException;
import al.aldi.sprova4j.models.aux.AuthenticationRequest;
import al.aldi.sprova4j.models.aux.AuthenticationResponse;
import al.aldi.sprova4j.utils.ApiUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connector {
    private static final Logger logger = LoggerFactory.getLogger(Connector.class);
    private final String API_ADDRESS;
    private final String JWT_KEY;
    private final String username;
    private final String password;
    private SprovaApiClient apiClient;

    public Connector(String apiAddress, String jwtKey) throws Exception {
        this.API_ADDRESS = ApiUtils.sanitizeUrl(apiAddress);
        this.JWT_KEY = jwtKey;
        this.username = null;
        this.password = null;
    }

    public Connector(String apiAddress, String username, String password) throws Exception {
        this.API_ADDRESS = ApiUtils.sanitizeUrl(apiAddress);
        this.username = username;
        this.password = password;
        this.JWT_KEY = this.authenticate(username, password);
    }

    public boolean authenticate() {
        return true;
    }

    protected String authenticate(String username, String password) throws IOException {
        String result = null;
        String url = this.API_ADDRESS + "/authenticate";
        AuthenticationRequest request = new AuthenticationRequest(username, password);
        String response = ApiUtils.post(url, request.toJson());
        AuthenticationResponse auth = AuthenticationResponse.toObject(response);
        result = auth.token;
        return result;
    }

    public SprovaApiClient getApiClient() {
        if (this.apiClient == null) {
            try {
                this.apiClient = new SprovaApiClient(this.API_ADDRESS, this.JWT_KEY);
            }
            catch (SprovaClientException e) {
                e.printStackTrace();
            }
        }
        return this.apiClient;
    }
}

