/*
 * Decompiled with CFR 0.152.
 */
package al.aldi.sprova4j;

import al.aldi.sprova4j.exections.CycleException;
import al.aldi.sprova4j.exections.ExecutionException;
import al.aldi.sprova4j.exections.SprovaClientException;
import al.aldi.sprova4j.exections.TestCaseException;
import al.aldi.sprova4j.models.Cycle;
import al.aldi.sprova4j.models.Execution;
import al.aldi.sprova4j.models.Project;
import al.aldi.sprova4j.models.TestCase;
import al.aldi.sprova4j.models.aux.PutExecutionResponse;
import al.aldi.sprova4j.utils.AuthorizationInterceptor;
import al.aldi.sprova4j.utils.LoggingInterceptor;
import java.io.IOException;
import java.util.List;
import javax.validation.constraints.NotNull;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SprovaApiClient {
    public final String API_URL;
    public final String JWT_TOKEN;
    private OkHttpClient client = null;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    protected SprovaApiClient(@NotNull String apiUrl, @NotNull String jwtToken) throws SprovaClientException {
        if (apiUrl == null) {
            throw new SprovaClientException("API_URL cannot be null");
        }
        if (jwtToken == null) {
            throw new SprovaClientException("JWT_TOKEN cannot be null");
        }
        this.API_URL = apiUrl;
        this.JWT_TOKEN = jwtToken;
        this.client = new OkHttpClient.Builder().addInterceptor((Interceptor)new LoggingInterceptor()).addInterceptor((Interceptor)new AuthorizationInterceptor(this.JWT_TOKEN)).build();
    }

    public Project getProject(String projectId) {
        try {
            Project project = Project.toObject(this.get(String.format("%s/%s", "/api/projects", projectId)));
            project.setClient(this);
            return project;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Cycle filterCycleByProjectId(String projectId, String jsonFiler) throws CycleException {
        Cycle result = null;
        try {
            result = Cycle.toObject(this.post(String.format("%s/%s/%s/findOne", "/api/projects", projectId, "cycles"), jsonFiler));
            if (result == null) {
                throw new CycleException("Cycle not found => filter: " + jsonFiler);
            }
            result.setClient(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Cycle> getCyclesByProjectId(String projectId) {
        List<Cycle> result = null;
        try {
            result = Cycle.toObjects(this.get(String.format("%s/%s/%s", "/api/projects", projectId, "cycles")));
            for (Cycle c : result) {
                c.setClient(this);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public TestCase filterTestCaseByCycleId(String cycleId, String jsonFiler) throws TestCaseException {
        TestCase result = null;
        try {
            result = TestCase.toObject(this.post(String.format("%s/%s/%s/findOne", "/api/cycles", cycleId, "testcases"), jsonFiler));
            if (result == null) {
                throw new TestCaseException("Test case not found => filter: " + jsonFiler);
            }
            result.setClient(this);
            result.cycleId = cycleId;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<TestCase> getTestCasesByProjectId(String projectId) {
        List<TestCase> result = null;
        try {
            result = TestCase.toObjects(this.get(String.format("%s/%s/%s", "/api/projects", projectId, "testcases")));
            for (TestCase t : result) {
                t.setClient(this);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<TestCase> getTestCasesByCycleId(String projectId) {
        List<TestCase> result = null;
        try {
            result = TestCase.toObjects(this.get(String.format("%s/%s/%s", "/api/cycles", projectId, "testcases")));
            for (TestCase t : result) {
                t.setClient(this);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Execution startExecution(Execution execution) {
        String jsonString = execution.toJson();
        try {
            PutExecutionResponse response = PutExecutionResponse.toObject(this.put("/api/executions", jsonString));
            if (response.ok != 1) {
                throw new ExecutionException("Could not start execution " + execution._id);
            }
            execution._id = response._id;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return execution;
    }

    public boolean passStep(Execution execution, int stepIndex) {
        return this.setStepStatus(execution, stepIndex, "pass");
    }

    public boolean failStep(Execution execution, int stepIndex) {
        return this.setStepStatus(execution, stepIndex, "fail");
    }

    private boolean setStepStatus(Execution execution, int stepIndex, String status) {
        boolean result = false;
        String jsonString = execution.toJson();
        try {
            PutExecutionResponse response = PutExecutionResponse.toObject(this.post(String.format("%s/%s/%s/%s/%s", "/api/executions", execution._id, "steps", stepIndex, status), jsonString));
            result = response.ok == 1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Execution passExecution(Execution execution) {
        return this.setExecutionStatus(execution, "pass");
    }

    public Execution failExecution(Execution execution) {
        return this.setExecutionStatus(execution, "fail");
    }

    private Execution setExecutionStatus(Execution execution, String status) {
        String jsonString = execution.toJson();
        try {
            PutExecutionResponse response = PutExecutionResponse.toObject(this.post(String.format("%s/%s/%s", "/api/executions", execution._id, status), jsonString));
            if (response.ok != 1) {
                throw new ExecutionException("Could not pass execution " + execution._id);
            }
            execution._id = response._id;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return execution;
    }

    public String get(String urlSuffix) throws IOException {
        String url = this.API_URL + urlSuffix;
        Request.Builder builder = this.getBuilder(url);
        Request request = builder.build();
        Response response = this.client.newCall(request).execute();
        return response.body().string();
    }

    public String post(String urlSuffix, String json) throws IOException {
        String url = this.API_URL + urlSuffix;
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request.Builder builder = this.getBuilder(url).post(body);
        Request request = builder.build();
        Response response = this.client.newCall(request).execute();
        return response.body().string();
    }

    public String put(String urlSuffix, String json) throws IOException {
        String url = this.API_URL + urlSuffix;
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request.Builder builder = this.getBuilder(url).put(body);
        Request request = builder.build();
        Response response = this.client.newCall(request).execute();
        return response.body().string();
    }

    private Request.Builder getBuilder(String url) {
        Request.Builder result = new Request.Builder().url(url);
        return result;
    }
}

