/*
 * Decompiled with CFR 0.152.
 */
package al.aldi.sprova4j.models;

import al.aldi.sprova4j.SprovaApiClient;
import al.aldi.sprova4j.exections.TestCaseException;
import al.aldi.sprova4j.models.Execution;
import al.aldi.sprova4j.models.SprovaObject;
import al.aldi.sprova4j.models.TestStep;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class TestCase
extends SprovaObject {
    public String _id;
    public String title;
    public String description;
    public String version;
    public String projectId;
    public String cycleId;
    public String parentId;
    public String status;
    public List<TestStep> testSteps;

    public Execution startExecution() throws TestCaseException {
        if (this.cycleId == null) {
            throw new TestCaseException("Cycle ID cannot be null");
        }
        Execution execution = this.getExecution();
        this.client.startExecution(execution);
        return execution;
    }

    private Execution getExecution() {
        Execution result = new Execution();
        result.setClient(this.client);
        result.testCaseId = this._id;
        result.cycleId = this.cycleId;
        result.title = this.title;
        result.description = this.description;
        result.testSteps = this.testSteps;
        result.status = "PENDING";
        result.executionType = "AUTOMATED";
        for (int i = 0; i < result.testSteps.size(); ++i) {
            result.testSteps.get((int)i).execution = result;
            result.testSteps.get((int)i).index = i;
        }
        return result;
    }

    @Override
    public void setClient(SprovaApiClient client) {
        this.client = client;
    }

    public static TestCase toObject(String json) {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return (TestCase)gson.fromJson(json, TestCase.class);
    }

    public static List<TestCase> toObjects(String json) {
        Type listType = new TypeToken<ArrayList<TestCase>>(){}.getType();
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return (List)gson.fromJson(json, listType);
    }
}

